/*
 * Decompiled with CFR 0.152.
 */
package com.altnoir.poopsky.combo;

import com.altnoir.poopsky.combo.KeyUtil;
import com.altnoir.poopsky.combo.PoopComboHandler;
import com.altnoir.poopsky.component.PSComponents;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class PoopComboHUD {
    private static final int HUD_X = 10;
    private static final int HUD_Y = 37;
    private static final int KEY_SPACING = 12;
    private static final int BACKGROUND_PADDING = 3;
    private static final int Y_OFFSET = 15;

    public static void render(class_332 context, class_9779 tickDelta) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_1799 stack = client.field_1724.method_6047();
        if (KeyUtil.isCtrlHeld() && KeyUtil.isHoldingPoopBall((class_1657)client.field_1724) && !stack.method_57826(PSComponents.POOP_BALL_COMPONENT)) {
            PoopComboHUD.renderComboDisplay(context);
        }
    }

    private static void renderComboDisplay(class_332 context) {
        class_310 client = class_310.method_1551();
        int yOffset = 0;
        int maxComboLength = PoopComboHandler.COMBO_LIST.stream().mapToInt(combo -> ((int[])combo).length).max().orElse(0);
        int boxWidth = maxComboLength * 12 - 3;
        for (int comboIndex = 0; comboIndex < PoopComboHandler.COMBO_LIST.size(); ++comboIndex) {
            int i;
            int[] combo2 = PoopComboHandler.COMBO_LIST.get(comboIndex);
            int currentY = 37 + yOffset;
            context.method_25294(7, currentY - 3, 10 + boxWidth, currentY + 12, Integer.MIN_VALUE);
            if (PoopComboHandler.isCoolingDown(comboIndex)) {
                int remaining = (int)((long)PoopComboHandler.COOL_DOWNS[comboIndex] - (client.field_1687.method_8510() - PoopComboHandler.lastTimes[comboIndex])) / 20;
                String text = String.format("%02d:%02d", remaining / 60, remaining % 60);
                context.method_25303(client.field_1772, text, 10, 37 + yOffset, 0xFFFFFF);
                yOffset += 15;
                continue;
            }
            List<Integer> inputBuffer = PoopComboHandler.inputBuffer;
            boolean skip = false;
            for (i = 0; i < inputBuffer.size(); ++i) {
                if (i < combo2.length && inputBuffer.get(i) == combo2[i]) continue;
                skip = true;
                break;
            }
            if (skip) {
                yOffset += 15;
                continue;
            }
            for (i = 0; i < combo2.length; ++i) {
                int color = 0xFFFFFF;
                if (i < inputBuffer.size()) {
                    color = 0x808080;
                }
                context.method_25303(client.field_1772, KeyUtil.getKey(combo2[i]), 10 + i * 12, currentY, color);
            }
            yOffset += 15;
        }
    }
}

