/*
 * Decompiled with CFR 0.152.
 */
package com.altnoir.poopsky.combo;

import com.altnoir.poopsky.combo.KeyUtil;
import com.altnoir.poopsky.component.PSComponents;
import com.altnoir.poopsky.keybinding.PoopBallPayload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class PoopComboHandler {
    public static final List<Integer> inputBuffer = new ArrayList<Integer>();
    private static final boolean[] keyStates = new boolean[KeyUtil.MOVEMENT_KEYS.length];
    public static final List<int[]> COMBO_LIST = new ArrayList<int[]>();
    public static long[] lastTimes = new long[0];
    public static int[] COOL_DOWNS = new int[0];

    public static void addCombo(String sequence, int coolDown) {
        COMBO_LIST.add(KeyUtil.parseSequence(sequence));
        COOL_DOWNS = Arrays.copyOf(COOL_DOWNS, COMBO_LIST.size());
        PoopComboHandler.COOL_DOWNS[PoopComboHandler.COMBO_LIST.size() - 1] = coolDown;
        lastTimes = Arrays.copyOf(lastTimes, COMBO_LIST.size());
    }

    public static void initialize() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            class_1799 stack = client.field_1724.method_6047();
            if (KeyUtil.isCtrlHeld() && KeyUtil.isHoldingPoopBall((class_1657)client.field_1724) && !stack.method_57826(PSComponents.POOP_BALL_COMPONENT)) {
                PoopComboHandler.handleInput(client);
            } else {
                inputBuffer.clear();
            }
        });
    }

    public static boolean isCoolingDown(int comboIndex) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || comboIndex < 0 || comboIndex >= COMBO_LIST.size()) {
            return false;
        }
        return client.field_1687.method_8510() - lastTimes[comboIndex] < (long)COOL_DOWNS[comboIndex];
    }

    private static void handleInput(class_310 client) {
        for (int i = 0; i < KeyUtil.MOVEMENT_KEYS.length; ++i) {
            int key = KeyUtil.MOVEMENT_KEYS[i];
            boolean isPressed = class_3675.method_15987((long)client.method_22683().method_4490(), (int)key);
            if (isPressed) {
                if (keyStates[i]) continue;
                PoopComboHandler.addKeyToBuffer(key);
                PoopComboHandler.keyStates[i] = true;
                continue;
            }
            PoopComboHandler.keyStates[i] = false;
        }
        PoopComboHandler.check();
    }

    private static void addKeyToBuffer(int key) {
        int currentMaxLength = IntStream.range(0, COMBO_LIST.size()).filter(comboIndex -> !PoopComboHandler.isCoolingDown(comboIndex)).map(comboIndex -> COMBO_LIST.get(comboIndex).length).filter(len -> len > inputBuffer.size()).max().orElse(0);
        if (currentMaxLength == 0) {
            return;
        }
        boolean anyMatch = IntStream.range(0, COMBO_LIST.size()).filter(comboIndex -> !PoopComboHandler.isCoolingDown(comboIndex)).anyMatch(comboIndex -> {
            int[] combo = COMBO_LIST.get(comboIndex);
            return inputBuffer.size() < combo.length && key == combo[inputBuffer.size()];
        });
        if (anyMatch) {
            PoopComboHandler.playKeySound(inputBuffer.size());
        } else {
            boolean allCooling = IntStream.range(0, COMBO_LIST.size()).allMatch(PoopComboHandler::isCoolingDown);
            if (!allCooling) {
                class_310.method_1551().field_1724.method_5783((class_3414)class_3417.field_18310.comp_349(), 0.5f, 0.6f);
            }
        }
        inputBuffer.add(key);
    }

    private static void check() {
        for (int comboIndex = 0; comboIndex < COMBO_LIST.size(); ++comboIndex) {
            if (PoopComboHandler.isCoolingDown(comboIndex)) continue;
            int[] combo2 = COMBO_LIST.get(comboIndex);
            boolean match = true;
            for (int i = 0; i < Math.min(inputBuffer.size(), combo2.length); ++i) {
                if (inputBuffer.get(i) == combo2[i]) continue;
                match = false;
                break;
            }
            if (!match || inputBuffer.size() != combo2.length) continue;
            inputBuffer.clear();
            PoopComboHandler.onCombo(comboIndex);
            return;
        }
        if (!inputBuffer.isEmpty() && !COMBO_LIST.stream().anyMatch(combo -> inputBuffer.size() <= ((int[])combo).length && combo[inputBuffer.size() - 1] == inputBuffer.get(inputBuffer.size() - 1))) {
            inputBuffer.clear();
        }
    }

    private static void onCombo(int comboIndex) {
        class_310 client = class_310.method_1551();
        class_1799 stack = client.field_1724.method_6047();
        if (client.field_1687 != null) {
            PoopComboHandler.lastTimes[comboIndex] = client.field_1687.method_8510();
        }
        if (!stack.method_57826(PSComponents.POOP_BALL_COMPONENT)) {
            if (comboIndex == 0) {
                ClientPlayNetworking.send((class_8710)new PoopBallPayload(1));
            } else if (comboIndex == 1) {
                ClientPlayNetworking.send((class_8710)new PoopBallPayload(2));
            }
        }
        client.field_1724.method_5783((class_3414)class_3417.field_14793.comp_349(), 0.5f, 1.0f);
    }

    private static void playKeySound(int i) {
        int maxComboLength = COMBO_LIST.stream().mapToInt(arr -> ((int[])arr).length).max().orElse(5);
        float pitch = 1.05f + 0.05f * (float)(i - maxComboLength);
        class_310.method_1551().field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.35f, pitch);
    }

    static {
        PoopComboHandler.addCombo("WSDAW", 2400);
        PoopComboHandler.addCombo("WDSSS", 1200);
    }
}

