/*
 * Decompiled with CFR 0.152.
 */
package com.altnoir.poopsky.entity;

import com.altnoir.poopsky.item.PSItems;
import com.altnoir.poopsky.keybinding.PlugActionPayload;
import com.altnoir.poopsky.sound.TPFlySoundWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_8103;
import org.joml.Vector3f;

public class ToiletPlugEntity
extends class_1690 {
    public float floatingValue = 0.0f;
    public float floatingCounts = 0.0f;
    public float prevFloatingValue = 0.0f;
    private class_1297 passenger;
    private TPFlySoundWrapper TPFlySound = null;
    private boolean isForward = false;
    private boolean isBackward = false;
    private boolean isLeft = false;
    private boolean isRight = false;
    private boolean isUp = false;
    private boolean isDown = false;
    private boolean isFast = false;
    private float yawVelocity = 0.0f;
    private float verVelocity = 0.0f;
    private static final float ACCELERATION = 0.1f;
    private int smooth = 0;
    private double smoothX;
    private double smoothY;
    private double smoothZ;
    float smoothYaw;
    float smoothPitch;

    public ToiletPlugEntity(class_1299<? extends class_1690> entityType, class_1937 world) {
        super(entityType, world);
        this.initializeSound();
    }

    private void initializeSound() {
        this.TPFlySound = new TPFlySoundWrapper(this);
    }

    public class_1792 method_7557() {
        return PSItems.TOILET_PLUG;
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < 2;
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        super.method_5865(passenger, positionUpdater);
        passenger.method_5814(passenger.method_23317(), passenger.method_23318() + 0.15 + (double)this.floatingValue, passenger.method_23321());
    }

    @Environment(value=EnvType.CLIENT)
    private void clientTick() {
        if (this.passenger != null) {
            if (!this.method_5782() && this.method_37908().field_9236 && class_310.method_1551().field_1724.method_5628() == this.passenger.method_5628()) {
                this.TPFlySound.stop();
                this.passenger = null;
            }
        } else if (this.method_5782() && this.method_31483().method_5628() == class_310.method_1551().field_1724.method_5628()) {
            this.TPFlySound.play();
            this.passenger = class_310.method_1551().field_1724;
        }
    }

    private void updateKeyStates() {
        this.isForward = class_310.method_1551().field_1690.field_1894.method_1434();
        this.isBackward = class_310.method_1551().field_1690.field_1881.method_1434();
        this.isLeft = class_310.method_1551().field_1690.field_1913.method_1434();
        this.isRight = class_310.method_1551().field_1690.field_1849.method_1434();
        this.isUp = class_310.method_1551().field_1690.field_1903.method_1434();
        this.isDown = PlugActionPayload.getDownKey().method_1434();
        boolean isSprintingNow = class_310.method_1551().field_1690.field_1867.method_1434();
        if (isSprintingNow) {
            this.isFast = true;
        }
        if (!this.isMoving()) {
            this.isFast = false;
        }
    }

    private void autoFall() {
        if (!this.method_5782()) {
            this.method_18800(0.0, -0.1, 0.0);
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
    }

    private boolean isMoving() {
        return this.isForward || this.isBackward || this.isLeft || this.isRight || this.isUp || this.isDown;
    }

    public void method_5773() {
        this.autoFall();
        if (this.method_37908().method_8608()) {
            this.clientTick();
            this.updateKeyStates();
            if (this.method_5782()) {
                if (class_310.method_1551().field_1724.method_5628() == this.method_31483().method_5628()) {
                    this.TPFlySound.tick();
                }
                this.spawnParticles();
            }
            if (this.method_5787()) {
                float MAX_SPEED = this.isFast ? 0.7f : 0.35f;
                float FBSpeed = 0.0f;
                if (this.isForward) {
                    FBSpeed = MAX_SPEED;
                }
                if (this.isBackward) {
                    FBSpeed = -MAX_SPEED;
                }
                float LRSpeed = 0.0f;
                if (this.isLeft) {
                    LRSpeed = MAX_SPEED;
                }
                if (this.isRight) {
                    LRSpeed = -MAX_SPEED;
                }
                float yawRad = (float)Math.toRadians(-this.method_36454());
                class_243 forwardVector = new class_243(Math.sin(yawRad), 0.0, Math.cos(yawRad)).method_1029();
                class_243 rightVector = new class_243(forwardVector.field_1350, 0.0, -forwardVector.field_1352).method_1029();
                class_243 movement = forwardVector.method_1021((double)FBSpeed).method_1019(rightVector.method_1021((double)LRSpeed));
                class_243 newVelocity = this.method_18798().method_1019(movement.method_1021((double)0.1f)).method_1021((double)0.975f);
                float target_g = 0.0f;
                if (this.isUp) {
                    target_g += MAX_SPEED;
                }
                if (this.isDown) {
                    target_g -= MAX_SPEED;
                }
                this.verVelocity = this.verVelocity * 0.9f + target_g * 0.1f;
                class_1297 passenger = this.method_31483();
                float targetYaw = passenger.method_36454();
                float ROTATION_SPEED = 0.3f;
                float deltaYaw = class_3532.method_15393((float)(targetYaw - this.method_36454()));
                this.method_36456(this.method_36454() + deltaYaw * 0.3f);
                this.method_18800(newVelocity.field_1352, this.verVelocity, newVelocity.field_1350);
                this.method_5784(class_1313.field_6308, this.method_18798());
            }
            this.smoothMovementFromOtherPlayer();
        }
        this.updateFloatingValue();
    }

    private void smoothMovementFromOtherPlayer() {
        if (this.method_5787()) {
            this.smooth = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.smooth > 0) {
            double d = this.method_23317() + (this.smoothX - this.method_23317()) / (double)this.smooth;
            double e = this.method_23318() + (this.smoothY - this.method_23318()) / (double)this.smooth;
            double f = this.method_23321() + (this.smoothZ - this.method_23321()) / (double)this.smooth;
            double g = class_3532.method_15338((double)((double)this.smoothYaw - (double)this.method_36454()));
            this.method_36456(this.method_36454() + (float)g / (float)this.smooth);
            this.method_36457(this.method_36455() + (float)((double)this.smoothPitch - (double)this.method_36455()) / (float)this.smooth);
            --this.smooth;
            this.method_5814(d, e, f);
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    private void updateFloatingValue() {
        this.prevFloatingValue = this.floatingValue;
        this.floatingCounts += 0.05f;
        if (this.floatingCounts > 6.28f) {
            this.floatingCounts -= 6.28f;
        }
        this.floatingValue = 0.1f * class_3532.method_15374((float)(2.0f * this.floatingCounts));
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        super.method_5759(x, y, z, yaw, pitch, interpolationSteps);
        this.smoothX = x;
        this.smoothY = y;
        this.smoothZ = z;
        this.smoothYaw = yaw;
        this.smoothPitch = pitch;
        this.smooth = 3;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236) {
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public boolean method_5679(class_1282 damageSource) {
        return super.method_5679(damageSource) || damageSource.method_48789(class_8103.field_42246);
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    public boolean method_30948() {
        return super.method_30948();
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_5715()) {
            this.method_5768();
            if (!player.method_7337() && !player.method_31548().method_7394(PSItems.TOILET_PLUG.method_7854())) {
                this.method_5706((class_1935)this.method_7557());
            }
            return true;
        }
        return super.method_5643(source, amount);
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnParticles() {
        class_1937 world = this.method_37908();
        class_243 velocity = this.method_18798();
        double speed = velocity.method_1033();
        if (speed > 0.1) {
            float yawRad = (float)Math.toRadians(this.method_36454());
            double offsetX = Math.sin(yawRad) * 0.55;
            double offsetZ = -Math.cos(yawRad) * 0.55;
            world.method_8406((class_2394)new class_2390(new Vector3f(0.4f, 0.25f, 0.0f), 2.0f), this.method_23317() + offsetX, this.method_23318() + 0.3 + (double)this.floatingValue, this.method_23321() + offsetZ, velocity.field_1352 * -0.1, velocity.field_1351 * 0.1, velocity.field_1350 * -0.1);
        }
    }

    public float getFloatingValue(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevFloatingValue, (float)this.floatingValue);
    }
}

