/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.function.Consumer;
import net.mcreator.durability.DurabilityConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnvilDurabilityEvents {
    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean isRepairMaterial;
        DyeColor color;
        if (!((Boolean)DurabilityConfig.COMMON.anvilAdditions.get()).booleanValue()) {
            return;
        }
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        String newName = event.getName();
        ItemStack output = left.m_41777_();
        CompoundTag tag = output.m_41784_();
        if (right.m_150930_(Items.f_42419_) && left.m_41763_() && !left.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("durability", "netherite_tools")))) {
            output.m_41721_(0);
            event.setOutput(output);
            event.setCost(0);
            event.setMaterialCost(1);
            return;
        }
        if (right.m_150930_(Items.f_42542_) && left.m_41763_()) {
            int repairAmount = left.m_41776_() / 4;
            int newDamage = Math.max(0, left.m_41773_() - repairAmount);
            output.m_41721_(newDamage);
            event.setOutput(output);
            event.setCost(0);
            event.setMaterialCost(1);
            return;
        }
        if (((Boolean)DurabilityConfig.COMMON.diamondDurability.get()).booleanValue() && right.m_150930_(Items.f_42415_) && left.m_41763_() && !left.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("durability", "diamond_tools")))) {
            int specialDurability = tag.m_128451_("SpecialDurability");
            tag.m_128405_("SpecialDurability", specialDurability + 32);
            output.m_41751_(tag);
            event.setOutput(output);
            event.setCost(1);
            event.setMaterialCost(1);
        }
        if (left.m_41720_() == Items.f_42680_ && newName != null && !newName.isEmpty()) {
            GameProfile profile = new GameProfile(null, newName);
            SkullBlockEntity.m_155738_((GameProfile)profile, completeProfile -> {
                if (completeProfile != null) {
                    CompoundTag ownerTag = new CompoundTag();
                    NbtUtils.m_129230_((CompoundTag)ownerTag, (GameProfile)completeProfile);
                    tag.m_128365_("SkullOwner", (Tag)ownerTag);
                    event.setOutput(output);
                }
            });
            event.setOutput(output);
            event.setCost(0);
        }
        if (right.m_204117_(Tags.Items.DYES) && (color = DyeColor.getColor((ItemStack)right)) != null) {
            int rgb = color.m_41071_();
            output.m_41714_((Component)Component.m_237113_((String)output.m_41786_().getString()).m_130938_(s -> s.m_178520_(rgb).m_131155_(Boolean.valueOf(false))));
            event.setOutput(output);
            event.setCost(0);
            return;
        }
        if (right.m_150930_(Items.f_42402_)) {
            output.m_41714_((Component)output.m_41786_().m_6881_().m_130938_(style -> style.m_131155_(Boolean.valueOf(true))));
            event.setOutput(output);
            event.setCost(0);
            return;
        }
        if (right.m_150930_(Items.f_42532_)) {
            output.m_41714_((Component)output.m_41786_().m_6881_().m_130938_(style -> style.m_131136_(Boolean.valueOf(true))));
            event.setOutput(output);
            event.setCost(0);
            return;
        }
        if (right.m_150930_(Items.f_42403_)) {
            output.m_41714_((Component)output.m_41786_().m_6881_().m_130938_(style -> style.m_178524_(Boolean.valueOf(true))));
            event.setOutput(output);
            event.setCost(0);
            return;
        }
        if (right.m_150930_(Items.f_42714_)) {
            tag.m_128405_("HideFlags", 127);
            output.m_41751_(tag);
            event.setOutput(output);
            event.setCost(1);
            event.setMaterialCost(1);
            return;
        }
        if (right.m_150930_(Items.f_151049_)) {
            tag.m_128379_("CustomGlint", true);
            output.m_41751_(tag);
            event.setOutput(output);
            event.setCost(0);
            event.setMaterialCost(1);
            return;
        }
        if (right.m_150930_(Items.f_42656_) && right.m_41788_()) {
            ListTag lore = new ListTag();
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)right.m_41786_())));
            CompoundTag display = tag.m_128469_("display");
            display.m_128365_("Lore", (Tag)lore);
            tag.m_128365_("display", (Tag)display);
            output.m_41751_(tag);
            event.setOutput(output);
            event.setCost(0);
            return;
        }
        if (((Boolean)DurabilityConfig.COMMON.soulboundItems.get()).booleanValue() && right.m_150930_(Items.f_220224_) && left.m_41613_() == 1) {
            tag.m_128379_("Soulbound", true);
            output.m_41751_(tag);
            event.setMaterialCost(1);
            event.setCost(5);
            event.setOutput(output);
        }
        if (right.m_150930_(Items.f_42696_)) {
            tag.m_128473_("HideFlags");
            tag.m_128473_("CustomGlint");
            CompoundTag display = tag.m_128469_("display");
            display.m_128473_("Lore");
            output.m_41751_(tag);
            event.setOutput(output);
            event.setCost(1);
            event.setMaterialCost(1);
        }
        boolean isRename = right.m_41619_();
        boolean bl = isRepairMaterial = !right.m_41619_() && left.m_41720_().m_6832_(left, right);
        if ((isRename || isRepairMaterial) && !event.getOutput().m_41619_()) {
            event.setCost(0);
            event.setMaterialCost(event.getMaterialCost());
        }
    }

    @SubscribeEvent
    public static void onWandererTrades(WandererTradesEvent event) {
        if (!((Boolean)DurabilityConfig.COMMON.wanderingEnchants.get()).booleanValue()) {
            return;
        }
        List<Enchantment> treasure = BuiltInRegistries.f_256876_.m_123024_().filter(Enchantment::m_6591_).toList();
        if (!treasure.isEmpty()) {
            VillagerTrades.ItemListing treasureTrade = (trader, random) -> {
                Enchantment chosen = (Enchantment)treasure.get(random.m_188503_(treasure.size()));
                int level = 1 + random.m_188503_(chosen.m_6586_());
                ItemStack book = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(chosen, level));
                ItemStack cost = new ItemStack((ItemLike)Items.f_42616_, 3 + random.m_188503_(3));
                return new MerchantOffer(cost, ItemStack.f_41583_, book, 1, 0, 0.05f);
            };
            List trades = event.getGenericTrades();
            if (trades.size() >= 6) {
                trades.set(5, treasureTrade);
            } else {
                trades.add(treasureTrade);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)DurabilityConfig.COMMON.specialToolDisplay.get()).booleanValue()) {
            return;
        }
        Player player = event.player;
        if (event.phase != TickEvent.Phase.END || player.m_9236_().f_46443_) {
            return;
        }
        Consumer<ItemStack> processItem = stack -> {
            if (stack.m_41619_()) {
                return;
            }
            if (stack.m_150930_(Items.f_42522_)) {
                CompoundTag tag = stack.m_41783_();
                if (tag != null && tag.m_128441_("LodestonePos")) {
                    CompoundTag posTag = tag.m_128469_("LodestonePos");
                    BlockPos lodestone = NbtUtils.m_129239_((CompoundTag)posTag);
                    boolean sameDim = true;
                    if (tag.m_128441_("LodestoneDimension")) {
                        ResourceLocation lodestoneDim = ResourceLocation.m_135820_((String)tag.m_128461_("LodestoneDimension"));
                        boolean bl = sameDim = lodestoneDim != null && lodestoneDim.equals((Object)player.m_9236_().m_46472_().m_135782_());
                    }
                    if (sameDim) {
                        int dx = (int)Math.round(player.m_20185_() - (double)lodestone.m_123341_());
                        int dz = (int)Math.round(player.m_20189_() - (double)lodestone.m_123343_());
                        player.m_5661_((Component)Component.m_237113_((String)("From Lodestone: X: " + dx + "  Z: " + dz)).m_130940_(ChatFormatting.AQUA), true);
                    } else {
                        player.m_5661_((Component)Component.m_237113_((String)"Lodestone in another dimension").m_130940_(ChatFormatting.RED), true);
                    }
                } else {
                    int x = (int)Math.floor(player.m_20185_());
                    int z = (int)Math.floor(player.m_20189_());
                    player.m_5661_((Component)Component.m_237113_((String)("X: " + x + "  Z: " + z)).m_130940_(ChatFormatting.YELLOW), true);
                }
            } else if (stack.m_150930_(Items.f_42524_)) {
                long dayTime = player.m_9236_().m_46468_() % 24000L;
                int hours = (int)((dayTime / 1000L + 6L) % 24L);
                int minutes = (int)((double)(dayTime % 1000L * 60L) / 1000.0);
                String timeStr = String.format("%02d:%02d", hours, minutes);
                player.m_5661_((Component)Component.m_237113_((String)("Time: " + timeStr)).m_130940_(ChatFormatting.YELLOW), true);
            } else if (stack.m_150930_(Items.f_151059_) && player.m_6117_()) {
                HitResult hit = player.m_19907_(256.0, 0.0f, false);
                if (hit.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult bhr = (BlockHitResult)hit;
                    BlockPos pos = bhr.m_82425_();
                    BlockState state = player.m_9236_().m_8055_(pos);
                    double dist = Math.sqrt(player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
                    String name = state.m_60734_().m_49954_().getString();
                    player.m_5661_((Component)Component.m_237113_((String)(name + " (" + (int)dist + "m)")).m_130940_(ChatFormatting.YELLOW), true);
                }
            } else if (stack.m_150930_(Items.f_220211_)) {
                player.m_219759_().ifPresent(deathPos -> {
                    if (deathPos.m_122640_() == player.m_9236_().m_46472_()) {
                        BlockPos pos = deathPos.m_122646_();
                        int dx = (int)Math.round(player.m_20185_() - (double)pos.m_123341_());
                        int dz = (int)Math.round(player.m_20189_() - (double)pos.m_123343_());
                        player.m_5661_((Component)Component.m_237113_((String)("From death: X: " + dx + "  Z: " + dz)).m_130940_(ChatFormatting.YELLOW), true);
                    }
                });
            }
        };
        processItem.accept(player.m_21205_());
        processItem.accept(player.m_21206_());
    }

    @SubscribeEvent
    public static void onItemBreak(PlayerDestroyItemEvent event) {
        ItemStack stack = event.getOriginal();
        if (!stack.m_41763_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int specialDurability = tag.m_128451_("SpecialDurability");
        if (specialDurability > 0) {
            tag.m_128405_("SpecialDurability", specialDurability - 1);
            ItemStack repaired = stack.m_41777_();
            repaired.m_41721_(stack.m_41776_() - 1);
            repaired.m_41751_(tag);
            event.getEntity().m_21008_(event.getHand(), repaired);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        int buffer;
        ItemStack stack = event.getItemStack();
        if (stack.m_41782_() && stack.m_41783_().m_128471_("Soulbound")) {
            event.getToolTip().add(Component.m_237113_((String)"Soulbound").m_130940_(ChatFormatting.AQUA));
        }
        if (stack.m_41763_() && (buffer = stack.m_41784_().m_128451_("SpecialDurability")) > 0) {
            event.getToolTip().add(Component.m_237113_((String)("Diamond Durability: " + buffer)).m_130940_(ChatFormatting.AQUA));
        }
    }
}

