/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability;

import java.util.List;
import net.mcreator.durability.DisguiseNetworking;
import net.mcreator.durability.DurabilityModMenuTypes;
import net.mcreator.durability.SyncOptionEnchantmentsPacket;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;

public class CustomEnchantmentMenu
extends AbstractContainerMenu {
    private final Container enchantSlots = new SimpleContainer(3){

        public void m_6596_() {
            super.m_6596_();
            CustomEnchantmentMenu.this.m_6199_((Container)this);
        }
    };
    private final ContainerLevelAccess access;
    private final RandomSource random = RandomSource.m_216327_();
    private final DataSlot enchantmentSeed = DataSlot.m_39401_();
    private EnchantmentInstance chosenBookEnchant = null;
    public final int[] costs = new int[3];
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] levelClue = new int[]{-1, -1, -1};
    private List<EnchantmentInstance>[] influencedOptions = new List[3];
    private List<EnchantmentInstance>[] normalOptions = new List[3];

    public CustomEnchantmentMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public CustomEnchantmentMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, ContainerLevelAccess.m_39289_((Level)inv.f_35978_.m_9236_(), (BlockPos)buf.m_130135_()));
    }

    public CustomEnchantmentMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)DurabilityModMenuTypes.CUSTOM_ENCHANTMENT.get(), containerId);
        this.access = access;
        this.m_38897_(new Slot(this.enchantSlots, 0, 15, 41){

            public boolean m_5857_(ItemStack stack) {
                return true;
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.enchantSlots, 1, 35, 41){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.m_38897_(new Slot(this.enchantSlots, 2, 25, 61){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42690_) || stack.m_150930_(Items.f_42517_) || stack.m_150930_(Items.f_220224_);
            }

            public int m_6641_() {
                return 1;
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)2));
        this.m_38895_(this.enchantmentSeed).m_6422_(playerInventory.f_35978_.m_36322_());
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)2));
        this.m_38895_(DataSlot.m_39406_((int[])this.levelClue, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.levelClue, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.levelClue, (int)2));
    }

    public void m_6199_(Container container) {
        if (container == this.enchantSlots) {
            ItemStack itemstack = container.m_8020_(0);
            ItemStack bookstack = container.m_8020_(2);
            if (!itemstack.m_41619_() && itemstack.m_41792_()) {
                this.access.m_39292_((level, pos) -> {
                    List<EnchantmentInstance> stored;
                    float bookshelfPower = 0.0f;
                    for (BlockPos offset : EnchantmentTableBlock.f_207902_) {
                        if (!EnchantmentTableBlock.m_207909_((Level)level, (BlockPos)pos, (BlockPos)offset)) continue;
                        bookshelfPower += level.m_8055_(pos.m_121955_((Vec3i)offset)).getEnchantPowerBonus((LevelReader)level, pos.m_121955_((Vec3i)offset));
                    }
                    this.random.m_188584_((long)this.enchantmentSeed.m_6501_());
                    this.chosenBookEnchant = null;
                    if (!bookstack.m_41619_() && bookstack.m_150930_(Items.f_42690_) && !(stored = EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)bookstack)).entrySet().stream().map(entry -> new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).filter(e -> e.f_44947_.m_6081_(itemstack)).toList()).isEmpty()) {
                        this.chosenBookEnchant = stored.get(this.random.m_188503_(stored.size()));
                    }
                    for (int slot = 0; slot < 3; ++slot) {
                        List<EnchantmentInstance> list;
                        this.costs[slot] = EnchantmentHelper.m_220287_((RandomSource)this.random, (int)slot, (int)((int)bookshelfPower), (ItemStack)itemstack);
                        this.enchantClue[slot] = -1;
                        this.levelClue[slot] = -1;
                        if (this.costs[slot] < slot + 1) {
                            this.costs[slot] = 0;
                        }
                        this.costs[slot] = ForgeEventFactory.onEnchantmentLevelSet((Level)level, (BlockPos)pos, (int)slot, (int)((int)bookshelfPower), (ItemStack)itemstack, (int)this.costs[slot]);
                        if (this.costs[slot] <= 0) continue;
                        if (this.chosenBookEnchant != null) {
                            list = this.buildInfluencedRoll(itemstack, slot, this.costs[slot], null);
                            this.influencedOptions[slot] = list;
                            this.normalOptions[slot] = null;
                        } else {
                            list = this.getEnchantmentList(itemstack, slot, this.costs[slot], null);
                            this.normalOptions[slot] = list;
                            this.influencedOptions[slot] = null;
                        }
                        if (list == null || list.isEmpty()) continue;
                        EnchantmentInstance pick = list.get(this.random.m_188503_(list.size()));
                        this.enchantClue[slot] = BuiltInRegistries.f_256876_.m_7447_((Object)pick.f_44947_);
                        this.levelClue[slot] = pick.f_44948_;
                    }
                    this.m_38946_();
                    if (level.m_7654_() != null) {
                        for (ServerPlayer sp : level.m_7654_().m_6846_().m_11314_()) {
                            if (sp.f_36096_ != this) continue;
                            for (int i = 0; i < 3; ++i) {
                                List<EnchantmentInstance> opts;
                                List<EnchantmentInstance> list = opts = this.influencedOptions[i] != null ? this.influencedOptions[i] : this.normalOptions[i];
                                if (opts == null) continue;
                                DisguiseNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new SyncOptionEnchantmentsPacket(this.f_38840_, i, opts));
                            }
                        }
                    }
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.costs[i] = 0;
                    this.enchantClue[i] = -1;
                    this.levelClue[i] = -1;
                }
            }
        }
    }

    public boolean m_6366_(Player player, int buttonId) {
        if (buttonId >= 0 && buttonId < this.costs.length) {
            ItemStack itemToEnchant = this.enchantSlots.m_8020_(0);
            ItemStack fuelStack = this.enchantSlots.m_8020_(1);
            ItemStack specialStack = this.enchantSlots.m_8020_(2);
            ItemStack carried = player.f_36096_.m_142621_();
            int cost = this.costs[buttonId];
            int lapisCost = buttonId + 1;
            int requiredLevel = cost;
            if (!specialStack.m_41619_() && specialStack.m_150930_(Items.f_220224_)) {
                requiredLevel = Math.max(1, requiredLevel / 2);
            }
            if (!carried.m_41619_() && carried.m_150930_(Items.f_151049_)) {
                int shardCost;
                List<EnchantmentInstance> current = this.influencedOptions[buttonId] != null ? this.influencedOptions[buttonId] : this.normalOptions[buttonId];
                int n = shardCost = current != null && !current.isEmpty() ? current.size() : 1;
                if (carried.m_41613_() < shardCost) {
                    return false;
                }
                carried.m_41774_(shardCost);
                this.access.m_39292_((level, pos) -> {
                    List<EnchantmentInstance> newList;
                    int rerollSeed = this.enchantmentSeed.m_6501_() + buttonId + level.f_46441_.m_188502_();
                    if (this.chosenBookEnchant != null) {
                        newList = this.buildInfluencedRoll(itemToEnchant, buttonId, cost, rerollSeed);
                        this.influencedOptions[buttonId] = newList;
                        this.normalOptions[buttonId] = null;
                    } else {
                        newList = this.getEnchantmentList(itemToEnchant, buttonId, cost, rerollSeed);
                        this.normalOptions[buttonId] = newList;
                        this.influencedOptions[buttonId] = null;
                    }
                    if (newList != null && !newList.isEmpty()) {
                        EnchantmentInstance pick = newList.get(this.random.m_188503_(newList.size()));
                        this.enchantClue[buttonId] = BuiltInRegistries.f_256876_.m_7447_((Object)pick.f_44947_);
                        this.levelClue[buttonId] = pick.f_44948_;
                    } else {
                        this.enchantClue[buttonId] = -1;
                        this.levelClue[buttonId] = -1;
                    }
                    this.m_38946_();
                    if (level.m_7654_() != null) {
                        for (ServerPlayer sp : level.m_7654_().m_6846_().m_11314_()) {
                            if (sp.f_36096_ != this) continue;
                            DisguiseNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new SyncOptionEnchantmentsPacket(this.f_38840_, buttonId, newList));
                        }
                    }
                    level.m_5594_(null, pos, SoundEvents.f_144243_, SoundSource.BLOCKS, 1.0f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                });
                return true;
            }
            if ((fuelStack.m_41619_() || fuelStack.m_41613_() < lapisCost) && !player.m_150110_().f_35937_) {
                return false;
            }
            if (cost <= 0 || itemToEnchant.m_41619_() || player.f_36078_ < requiredLevel && !player.m_150110_().f_35937_) {
                return false;
            }
            this.access.m_39292_((level, pos) -> {
                ItemStack resultStack = itemToEnchant;
                List<EnchantmentInstance> enchantments = !this.enchantSlots.m_8020_(2).m_41619_() && this.influencedOptions[buttonId] != null ? this.influencedOptions[buttonId] : (this.normalOptions[buttonId] != null ? this.normalOptions[buttonId] : this.getEnchantmentList(itemToEnchant, buttonId, cost, null));
                if (!enchantments.isEmpty()) {
                    player.m_7408_(itemToEnchant, lapisCost);
                    boolean isBook = itemToEnchant.m_150930_(Items.f_42517_);
                    if (isBook) {
                        resultStack = new ItemStack((ItemLike)Items.f_42690_);
                        CompoundTag tag = itemToEnchant.m_41783_();
                        if (tag != null) {
                            resultStack.m_41751_(tag.m_6426_());
                        }
                        this.enchantSlots.m_6836_(0, resultStack);
                    }
                    for (EnchantmentInstance enchantment : enchantments) {
                        if (isBook) {
                            EnchantedBookItem.m_41153_((ItemStack)resultStack, (EnchantmentInstance)enchantment);
                            continue;
                        }
                        resultStack.m_41663_(enchantment.f_44947_, enchantment.f_44948_);
                    }
                    if (!player.m_150110_().f_35937_) {
                        fuelStack.m_41774_(lapisCost);
                        if (fuelStack.m_41619_()) {
                            this.enchantSlots.m_6836_(1, ItemStack.f_41583_);
                        }
                        if (specialStack.m_150930_(Items.f_220224_)) {
                            specialStack.m_41774_(1);
                            if (specialStack.m_41619_()) {
                                this.enchantSlots.m_6836_(2, ItemStack.f_41583_);
                            }
                        }
                    }
                    player.m_36220_(Stats.f_12964_);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10575_.m_27668_(serverPlayer, resultStack, lapisCost);
                    }
                    this.enchantSlots.m_6596_();
                    this.enchantmentSeed.m_6422_(player.m_36322_());
                    this.m_6199_(this.enchantSlots);
                    level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                }
            });
            return true;
        }
        Util.m_143785_((String)(player.m_7755_() + " pressed invalid button id: " + buttonId));
        return false;
    }

    public void setClientOptionEnchantments(int slot, List<EnchantmentInstance> list) {
        if (slot >= 0 && slot < this.normalOptions.length) {
            this.normalOptions[slot] = list;
        }
        if (slot >= 0 && slot < this.influencedOptions.length) {
            this.influencedOptions[slot] = list;
        }
    }

    private List<EnchantmentInstance> rollExtraVanilla(ItemStack stack, int slot, int cost) {
        this.random.m_188584_((long)(this.enchantmentSeed.m_6501_() + slot + 1337));
        return EnchantmentHelper.m_220297_((RandomSource)this.random, (ItemStack)stack, (int)cost, (boolean)false);
    }

    private List<EnchantmentInstance> addBookInfluence(List<EnchantmentInstance> base, ItemStack bookstack, int slot, int cost) {
        if (bookstack.m_41619_() || !bookstack.m_150930_(Items.f_42690_)) {
            return base;
        }
        List<EnchantmentInstance> stored = EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)bookstack)).entrySet().stream().map(entry -> new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).toList();
        if (!stored.isEmpty()) {
            EnchantmentInstance forced = stored.get(this.random.m_188503_(stored.size()));
            int scaledLevel = Math.max(1, cost / 30 * forced.f_44947_.m_6586_());
            if (scaledLevel <= 0) {
                scaledLevel = 1;
            }
            scaledLevel = Math.min(forced.f_44947_.m_6586_(), scaledLevel);
            base.add(new EnchantmentInstance(forced.f_44947_, scaledLevel));
        }
        return base;
    }

    private List<EnchantmentInstance> buildInfluencedRoll(ItemStack stack, int slot, int cost, Integer customSeed) {
        long seed = customSeed != null ? (long)customSeed.intValue() : (long)(this.enchantmentSeed.m_6501_() + slot + 1337 + BuiltInRegistries.f_256876_.m_7447_((Object)this.chosenBookEnchant.f_44947_));
        this.random.m_188584_(seed);
        List list = EnchantmentHelper.m_220297_((RandomSource)this.random, (ItemStack)stack, (int)cost, (boolean)false);
        if (this.chosenBookEnchant != null) {
            int scaledLevel = (int)Math.ceil((double)cost / 30.0 * (double)this.chosenBookEnchant.f_44947_.m_6586_());
            scaledLevel = Math.max(1, Math.min(this.chosenBookEnchant.f_44947_.m_6586_(), scaledLevel));
            boolean merged = false;
            for (int i = 0; i < list.size(); ++i) {
                EnchantmentInstance inst = (EnchantmentInstance)list.get(i);
                if (inst.f_44947_ != this.chosenBookEnchant.f_44947_) continue;
                list.set(i, new EnchantmentInstance(inst.f_44947_, Math.max(inst.f_44948_, scaledLevel)));
                merged = true;
                break;
            }
            if (!merged) {
                list.add(new EnchantmentInstance(this.chosenBookEnchant.f_44947_, scaledLevel));
            }
        }
        return list;
    }

    private List<EnchantmentInstance> getEnchantmentList(ItemStack stack, int slot, int cost, Integer customSeed) {
        long seed = customSeed != null ? (long)customSeed.intValue() : (long)(this.enchantmentSeed.m_6501_() + slot);
        this.random.m_188584_(seed);
        List list = EnchantmentHelper.m_220297_((RandomSource)this.random, (ItemStack)stack, (int)cost, (boolean)false);
        if (stack.m_150930_(Items.f_42517_) && list.size() > 1) {
            list.remove(this.random.m_188503_(list.size()));
        }
        return list;
    }

    public int getFuelCount() {
        ItemStack stack = this.enchantSlots.m_8020_(1);
        return stack.m_41619_() ? 0 : stack.m_41613_();
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed.m_6501_();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((level, pos) -> this.m_150411_(player, this.enchantSlots));
    }

    public boolean m_6875_(Player player) {
        return CustomEnchantmentMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)Blocks.f_50201_);
    }

    public List<EnchantmentInstance> getOptionEnchantments(int slot, boolean influenced) {
        return influenced ? this.getInfluencedOptionEnchantments(slot) : this.getNormalOptionEnchantments(slot);
    }

    public List<EnchantmentInstance> getNormalOptionEnchantments(int slot) {
        if (slot >= 0 && slot < this.normalOptions.length) {
            return this.normalOptions[slot];
        }
        return null;
    }

    public List<EnchantmentInstance> getInfluencedOptionEnchantments(int slot) {
        if (slot >= 0 && slot < this.influencedOptions.length) {
            return this.influencedOptions[slot];
        }
        return null;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index == 0 || index == 1 || index == 2 ? !this.m_38903_(slotStack, 3, 39, true) : (slotStack.m_204117_(Tags.Items.ENCHANTING_FUELS) ? !this.m_38903_(slotStack, 1, 2, false) : (slotStack.m_150930_(Items.f_42690_) ? !this.m_38903_(slotStack, 2, 3, false) : (((Slot)this.f_38839_.get(0)).m_5857_(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : (index < 30 ? !this.m_38903_(slotStack, 30, 39, false) : index < 39 && !this.m_38903_(slotStack, 3, 30, false)))))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }
}

