/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.durability.CustomEnchantmentMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomEnchantmentScreen
extends AbstractContainerScreen<CustomEnchantmentMenu> {
    private static final ResourceLocation ENCHANTING_TABLE_LOCATION = new ResourceLocation("durability:textures/screens/enchanting_table.png");
    private static final ResourceLocation ENCHANTING_BOOK_LOCATION = new ResourceLocation("textures/entity/enchanting_table_book.png");
    private final RandomSource random = RandomSource.m_216327_();
    private BookModel bookModel;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.f_41583_;

    public CustomEnchantmentScreen(CustomEnchantmentMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void m_7856_() {
        super.m_7856_();
        this.bookModel = new BookModel(this.f_96541_.m_167973_().m_171103_(ModelLayers.f_171271_));
    }

    public void m_181908_() {
        super.m_181908_();
        this.tickBook();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        for (int k = 0; k < 3; ++k) {
            double dx = mouseX - (double)(i + 60);
            double dy = mouseY - (double)(j + 14 + 19 * k);
            if (!(dx >= 0.0) || !(dy >= 0.0) || !(dx < 108.0) || !(dy < 19.0) || !((CustomEnchantmentMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, k)) continue;
            this.f_96541_.f_91072_.m_105208_(((CustomEnchantmentMenu)this.f_97732_).f_38840_, k);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(ENCHANTING_TABLE_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        this.renderBook(graphics, i, j, partialTicks);
        EnchantmentNames.m_98734_().m_98735_((long)((CustomEnchantmentMenu)this.f_97732_).getEnchantmentSeed());
        int fuel = ((CustomEnchantmentMenu)this.f_97732_).getFuelCount();
        for (int l = 0; l < 3; ++l) {
            int x = i + 60;
            int textX = x + 20;
            int cost = ((CustomEnchantmentMenu)this.f_97732_).costs[l];
            if (cost == 0) {
                graphics.m_280218_(ENCHANTING_TABLE_LOCATION, x, j + 14 + 19 * l, 0, 185, 108, 19);
                continue;
            }
            int requiredLevel = cost;
            ItemStack specialStack = ((CustomEnchantmentMenu)this.f_97732_).m_38853_(2).m_7993_();
            if (!specialStack.m_41619_() && specialStack.m_150930_(Items.f_220224_)) {
                requiredLevel = Math.max(1, requiredLevel / 2);
            }
            String costStr = "" + requiredLevel;
            int maxWidth = 86 - this.f_96547_.m_92895_(costStr);
            FormattedText randName = EnchantmentNames.m_98734_().m_98737_(this.f_96547_, maxWidth);
            int color = 6839882;
            if ((fuel < l + 1 || this.f_96541_.f_91074_.f_36078_ < requiredLevel) && !this.f_96541_.f_91074_.m_150110_().f_35937_ || ((CustomEnchantmentMenu)this.f_97732_).enchantClue[l] == -1) {
                graphics.m_280218_(ENCHANTING_TABLE_LOCATION, x, j + 14 + 19 * l, 0, 185, 108, 19);
                graphics.m_280218_(ENCHANTING_TABLE_LOCATION, x + 1, j + 15 + 19 * l, 16 * l, 239, 16, 16);
                graphics.m_280554_(this.f_96547_, randName, textX, j + 16 + 19 * l, maxWidth, (color & 0xFEFEFE) >> 1);
                color = 4226832;
            } else {
                int dx = mouseX - (i + 60);
                int dy = mouseY - (j + 14 + 19 * l);
                if (dx >= 0 && dy >= 0 && dx < 108 && dy < 19) {
                    graphics.m_280218_(ENCHANTING_TABLE_LOCATION, x, j + 14 + 19 * l, 0, 204, 108, 19);
                    color = 0xFFFF80;
                } else {
                    graphics.m_280218_(ENCHANTING_TABLE_LOCATION, x, j + 14 + 19 * l, 0, 166, 108, 19);
                }
                graphics.m_280218_(ENCHANTING_TABLE_LOCATION, x + 1, j + 15 + 19 * l, 16 * l, 223, 16, 16);
                graphics.m_280554_(this.f_96547_, randName, textX, j + 16 + 19 * l, maxWidth, color);
                color = 8453920;
            }
            graphics.m_280488_(this.f_96547_, costStr, textX + 86 - this.f_96547_.m_92895_(costStr), j + 16 + 19 * l + 7, color);
        }
    }

    private void renderBook(GuiGraphics graphics, int x, int y, float partialTicks) {
        float f = Mth.m_14179_((float)partialTicks, (float)this.oOpen, (float)this.open);
        float f1 = Mth.m_14179_((float)partialTicks, (float)this.oFlip, (float)this.flip);
        Lighting.m_166384_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x + 33.0f, (float)y + 21.0f, 100.0f);
        graphics.m_280168_().m_85841_(-40.0f, 40.0f, 40.0f);
        graphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(25.0f));
        graphics.m_280168_().m_252880_((1.0f - f) * 0.2f, (1.0f - f) * 0.1f, (1.0f - f) * 0.25f);
        float rotY = -(1.0f - f) * 90.0f - 90.0f;
        graphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(rotY));
        graphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float leftPage = Mth.m_14036_((float)(Mth.m_14187_((float)(f1 + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        float rightPage = Mth.m_14036_((float)(Mth.m_14187_((float)(f1 + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        this.bookModel.m_102292_(0.0f, leftPage, rightPage, f);
        VertexConsumer consumer = graphics.m_280091_().m_6299_(this.bookModel.m_103119_(ENCHANTING_BOOK_LOCATION));
        this.bookModel.m_7695_(graphics.m_280168_(), consumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280262_();
        graphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.f_96541_.m_91296_();
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        boolean creative = this.f_96541_.f_91074_.m_150110_().f_35937_;
        int fuel = ((CustomEnchantmentMenu)this.f_97732_).getFuelCount();
        ItemStack carried = this.f_96541_.f_91074_.f_36096_.m_142621_();
        boolean holdingSpyglass = !carried.m_41619_() && carried.m_150930_(Items.f_151059_);
        for (int j = 0; j < 3; ++j) {
            int cost = ((CustomEnchantmentMenu)this.f_97732_).costs[j];
            if (cost <= 0) continue;
            int lapisCost = j + 1;
            if (!this.m_6774_(60, 14 + 19 * j, 108, 17, mouseX, mouseY)) continue;
            ArrayList tooltip = Lists.newArrayList();
            if (holdingSpyglass) {
                List<EnchantmentInstance> enchants = ((CustomEnchantmentMenu)this.f_97732_).getInfluencedOptionEnchantments(j);
                if (enchants == null || enchants.isEmpty()) {
                    enchants = ((CustomEnchantmentMenu)this.f_97732_).getNormalOptionEnchantments(j);
                }
                if (enchants != null && !enchants.isEmpty()) {
                    for (EnchantmentInstance inst : enchants) {
                        tooltip.add(inst.f_44947_.m_44700_(inst.f_44948_).m_6881_().m_130940_(ChatFormatting.GRAY));
                    }
                } else {
                    tooltip.add(Component.m_237115_((String)"container.enchant.nooptions").m_130940_(ChatFormatting.RED));
                }
            } else {
                Enchantment enchantment = Enchantment.m_44697_((int)((CustomEnchantmentMenu)this.f_97732_).enchantClue[j]);
                int level = ((CustomEnchantmentMenu)this.f_97732_).levelClue[j];
                tooltip.add(Component.m_237110_((String)"container.enchant.clue", (Object[])new Object[]{enchantment == null ? "" : enchantment.m_44700_(level)}).m_130940_(ChatFormatting.WHITE));
                if (enchantment == null) {
                    tooltip.add(Component.m_237113_((String)""));
                    tooltip.add(Component.m_237115_((String)"forge.container.enchant.limitedEnchantability").m_130940_(ChatFormatting.RED));
                } else if (!creative) {
                    tooltip.add(CommonComponents.f_237098_);
                    int requiredLevel = cost;
                    ItemStack specialStack = ((CustomEnchantmentMenu)this.f_97732_).m_38853_(2).m_7993_();
                    if (!specialStack.m_41619_() && specialStack.m_150930_(Items.f_220224_)) {
                        requiredLevel = Math.max(1, requiredLevel / 2);
                    }
                    if (this.f_96541_.f_91074_.f_36078_ < requiredLevel) {
                        tooltip.add(Component.m_237110_((String)"container.enchant.level.requirement", (Object[])new Object[]{requiredLevel}).m_130940_(ChatFormatting.RED));
                    } else {
                        MutableComponent lapisText = lapisCost == 1 ? Component.m_237115_((String)"container.enchant.lapis.one") : Component.m_237110_((String)"container.enchant.lapis.many", (Object[])new Object[]{lapisCost});
                        tooltip.add(lapisText.m_130940_(fuel >= lapisCost ? ChatFormatting.GRAY : ChatFormatting.RED));
                        MutableComponent levelText = lapisCost == 1 ? Component.m_237115_((String)"container.enchant.level.one") : Component.m_237110_((String)"container.enchant.level.many", (Object[])new Object[]{lapisCost});
                        tooltip.add(levelText.m_130940_(ChatFormatting.GRAY));
                    }
                }
            }
            graphics.m_280666_(this.f_96547_, (List)tooltip, mouseX, mouseY);
            break;
        }
    }

    public void tickBook() {
        ItemStack itemstack = ((CustomEnchantmentMenu)this.f_97732_).m_38853_(0).m_7993_();
        if (!ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)this.last)) {
            this.last = itemstack;
            do {
                this.flipT += (float)(this.random.m_188503_(4) - this.random.m_188503_(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.time;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean hasEnchant = false;
        for (int i = 0; i < 3; ++i) {
            if (((CustomEnchantmentMenu)this.f_97732_).costs[i] == 0) continue;
            hasEnchant = true;
        }
        this.open = hasEnchant ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = Mth.m_14036_((float)this.open, (float)0.0f, (float)1.0f);
        float delta = (this.flipT - this.flip) * 0.4f;
        delta = Mth.m_14036_((float)delta, (float)-0.2f, (float)0.2f);
        this.flipA += (delta - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

