/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.mcreator.durability.DisguiseData;
import net.mcreator.durability.LegacySkinConverterCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class DisguiseManager {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static final Map<String, DisguiseData> SKIN_CACHE = new ConcurrentHashMap<String, DisguiseData>();
    private static final Set<String> REQUESTING = ConcurrentHashMap.newKeySet();

    public static DisguiseData getSkinForUsername(String username) {
        String lower = username.toLowerCase(Locale.ROOT);
        if (SKIN_CACHE.containsKey(lower)) {
            return SKIN_CACHE.get(lower);
        }
        if (!REQUESTING.contains(lower)) {
            REQUESTING.add(lower);
            EXECUTOR.submit(() -> DisguiseManager.fetchSkin(lower));
        }
        return null;
    }

    private static void fetchSkin(String username) {
        try {
            JsonObject metadata;
            URL profileUrl = new URL("https://api.mojang.com/users/profiles/minecraft/" + username);
            JsonObject profileJson = DisguiseManager.readJson(profileUrl);
            if (profileJson == null || !profileJson.has("id")) {
                REQUESTING.remove(username);
                return;
            }
            String uuid = profileJson.get("id").getAsString();
            URL sessionUrl = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
            JsonObject sessionJson = DisguiseManager.readJson(sessionUrl);
            if (sessionJson == null || !sessionJson.has("properties")) {
                REQUESTING.remove(username);
                return;
            }
            JsonObject properties = sessionJson.getAsJsonArray("properties").get(0).getAsJsonObject();
            String value = properties.get("value").getAsString();
            String decoded = new String(Base64.getDecoder().decode(value));
            JsonObject skinJson = JsonParser.parseString((String)decoded).getAsJsonObject();
            if (!skinJson.has("textures")) {
                REQUESTING.remove(username);
                return;
            }
            JsonObject textures = skinJson.getAsJsonObject("textures");
            if (!textures.has("SKIN")) {
                REQUESTING.remove(username);
                return;
            }
            String skinUrl = textures.getAsJsonObject("SKIN").get("url").getAsString();
            InputStream inputStream = new URL(skinUrl).openStream();
            NativeImage image = NativeImage.m_85058_((InputStream)inputStream);
            inputStream.close();
            image = LegacySkinConverterCompat.upgrade(image);
            JsonObject skinObj = textures.getAsJsonObject("SKIN");
            boolean slim = false;
            if (skinObj.has("metadata") && (metadata = skinObj.getAsJsonObject("metadata")).has("model") && "slim".equals(metadata.get("model").getAsString())) {
                slim = true;
            }
            NativeImage finalImage = image;
            ResourceLocation skinLoc = new ResourceLocation("durability", "skins/" + username);
            boolean finalSlim = slim;
            Minecraft.m_91087_().execute(() -> {
                DynamicTexture tex = new DynamicTexture(finalImage);
                Minecraft.m_91087_().m_91097_().m_118495_(skinLoc, (AbstractTexture)tex);
                SKIN_CACHE.put(username, new DisguiseData(skinLoc, finalSlim));
                REQUESTING.remove(username);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            REQUESTING.remove(username);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject readJson(URL url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "Minecraft");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            try (InputStream input = conn.getInputStream();){
                Scanner scanner = new Scanner(input).useDelimiter("\\A");
                try {
                    String body = scanner.hasNext() ? scanner.next() : "";
                    JsonObject jsonObject = JsonParser.parseString((String)body).getAsJsonObject();
                    if (scanner != null) {
                        scanner.close();
                    }
                    return jsonObject;
                }
                catch (Throwable throwable) {
                    if (scanner != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
    }
}

