/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability;

import net.minecraftforge.common.ForgeConfigSpec;

public class DurabilityConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        COMMON = new Common(builder);
        COMMON_SPEC = builder.build();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enableTemplateDurability;
        public final ForgeConfigSpec.BooleanValue isHorseArmorEnchant;
        public final ForgeConfigSpec.BooleanValue fletchingUse;
        public final ForgeConfigSpec.BooleanValue enableItemStackIncrease;
        public final ForgeConfigSpec.BooleanValue customEnchanting;
        public final ForgeConfigSpec.BooleanValue enableBookRarity;
        public final ForgeConfigSpec.BooleanValue weaponEnchTools;
        public final ForgeConfigSpec.BooleanValue removeEnchMutex;
        public final ForgeConfigSpec.BooleanValue enableAnvilRepairCost;
        public final ForgeConfigSpec.BooleanValue enableAnvilRequirement;
        public final ForgeConfigSpec.DoubleValue anvilXpScaling;
        public final ForgeConfigSpec.BooleanValue fullArmorEnchantGlint;
        public final ForgeConfigSpec.BooleanValue swordBlocking;
        public final ForgeConfigSpec.BooleanValue projectileIFrames;
        public final ForgeConfigSpec.BooleanValue bowUseInaccuracy;
        public final ForgeConfigSpec.BooleanValue swordAutoSwing;
        public final ForgeConfigSpec.BooleanValue anvilAdditions;
        public final ForgeConfigSpec.BooleanValue soulboundItems;
        public final ForgeConfigSpec.BooleanValue diamondDurability;
        public final ForgeConfigSpec.BooleanValue wanderingEnchants;
        public final ForgeConfigSpec.BooleanValue specialToolDisplay;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("durability");
            this.enableTemplateDurability = builder.comment("Enable durability on Smithing Templates").define("enableTemplateDurability", true);
            this.isHorseArmorEnchant = builder.comment("Allow horse armor to be enchanted like regular armor").define("isHorseArmorEnchant", true);
            this.fletchingUse = builder.comment("Enable fletching table GUI").define("fletchingUse", true);
            this.wanderingEnchants = builder.comment("Enable wandering traders to sell treasure enchantments").define("wanderingEnchants", true);
            this.specialToolDisplay = builder.comment("Enable special tool displays (compass coords, clock time, spyglass info, recovery compass distance)").define("specialToolDisplay", true);
            builder.pop();
            builder.push("stacking");
            this.enableItemStackIncrease = builder.comment("Enable custom stack size increases").define("enableItemStackIncrease", true);
            builder.pop();
            builder.push("enchanted_books");
            this.customEnchanting = builder.comment("Enable custom enchanting system").define("customEnchanting", true);
            this.enableBookRarity = builder.comment("Enable rarity override for enchanted books").define("enableBookRarity", true);
            this.weaponEnchTools = builder.comment("Allow weapon enchantments (e.g. Sharpness, Smite, Looting) to apply to tools like pickaxes, axes, and shovels").define("weaponEnchTools", true);
            this.removeEnchMutex = builder.comment("Allow normally mutually exclusive enchantments to coexist (e.g. Sharpness + Smite, Protection + Fire Prot, Infinity + Mending, Multishot + Piercing)").define("removeEnchMutex", true);
            builder.pop();
            builder.push("anvil");
            this.enableAnvilRepairCost = builder.comment("Enable anvil repair/rename costs (false = free repairs/renames)").define("enableAnvilRepairCost", true);
            this.enableAnvilRequirement = builder.comment("Enable anvil XP requirement clamp (false = no 'Too Expensive', XP cost as % only)").define("enableAnvilRequirement", true);
            this.anvilXpScaling = builder.comment("Scaling factor for XP cost when using an anvil. Ex. 0.1 = 10%, 0.5 = 50%, 1.0 = 100%").defineInRange("anvilXpScaling", 0.1, 0.0, 1.0);
            this.anvilAdditions = builder.comment("Enable custom anvil additions (special item interactions)").define("anvilAdditions", true);
            this.soulboundItems = builder.comment("Enable Soulbound mechanic (Echo Shard in anvil)").define("soulboundItems", true);
            this.diamondDurability = builder.comment("Enable Diamond Durability mechanic (item undying from breaking from diamonds in anvil)").define("diamondDurability", true);
            builder.pop();
            builder.push("visuals");
            this.fullArmorEnchantGlint = builder.comment("Show a glint effect when wearing a full enchanted armor set").define("fullArmorEnchantGlint", true);
            builder.pop();
            builder.push("combat");
            this.swordBlocking = builder.comment("Enable blocking with swords (reflect, reduce, and cancel knockback)").define("swordBlocking", true);
            this.projectileIFrames = builder.comment("Disable i-frames (invulnerability ticks) for projectile damage").define("projectileIFrames", true);
            this.bowUseInaccuracy = builder.comment("Enable extra bow inaccuracy and crit cancel if overdrawn (holding past 30 ticks)").define("bowUseInaccuracy", true);
            this.swordAutoSwing = builder.comment("Enable hold-to-attack autoswing for swords (continuous attacks while holding left-click)").define("swordAutoSwing", true);
            builder.pop();
        }
    }
}

