/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability;

import java.util.ArrayList;
import java.util.List;
import net.mcreator.durability.DurabilityModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FletchingMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Container inputSlots = new SimpleContainer(6){

        public void m_6596_() {
            super.m_6596_();
            FletchingMenu.this.m_6199_((Container)this);
        }
    };
    private final ResultContainer resultSlot = new ResultContainer();

    public FletchingMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, ContainerLevelAccess.m_39289_((Level)inv.f_35978_.m_9236_(), (BlockPos)buf.m_130135_()));
    }

    public FletchingMenu(int id, Inventory inv, ContainerLevelAccess access) {
        super((MenuType)DurabilityModMenuTypes.FLETCHING_MENU.get(), id);
        this.access = access;
        this.m_38897_(new Slot(this.inputSlots, 0, 18, 47){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42412_) || stack.m_150930_(Items.f_42738_) || stack.m_150930_(Items.f_42516_) || stack.m_150930_(Items.f_42403_);
            }
        });
        for (int i = 1; i <= 4; ++i) {
            int x = i % 2 == 0 ? 85 : 67;
            int y = i < 3 ? 38 : 56;
            this.m_38897_(new Slot(this.inputSlots, i, x, y){

                public boolean m_5857_(ItemStack stack) {
                    return stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42403_) || stack.m_41720_().toString().endsWith("_dye") || stack.m_150930_(Items.f_42415_) || stack.m_150930_(Items.f_42525_) || stack.m_150930_(Items.f_42613_) || stack.m_150930_(Items.f_42402_) || stack.m_150930_(Items.f_42587_) || stack.m_41720_().toString().contains("head") || stack.m_150930_(Items.f_42689_);
                }

                public int m_5866_(ItemStack stack) {
                    if (stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_)) {
                        return 1;
                    }
                    return super.m_5866_(stack);
                }
            });
        }
        this.m_38897_(new Slot((Container)this.resultSlot, 5, 143, 47){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                player.m_5496_(SoundEvents.f_12569_, 1.0f, 1.0f);
                if (stack.m_150930_(Items.f_42688_)) {
                    int batches = stack.m_41613_() / 8;
                    ItemStack paper = FletchingMenu.this.inputSlots.m_8020_(0);
                    paper.m_41774_(batches);
                    if (paper.m_41619_()) {
                        FletchingMenu.this.inputSlots.m_6836_(0, ItemStack.f_41583_);
                    }
                    int remaining = batches;
                    for (int i = 1; i <= 4 && remaining > 0; ++i) {
                        ItemStack gp = FletchingMenu.this.inputSlots.m_8020_(i);
                        if (!gp.m_150930_(Items.f_42403_) && !gp.m_150930_(Items.f_42689_)) continue;
                        int toTake = Math.min(remaining, gp.m_41613_());
                        gp.m_41774_(toTake);
                        remaining -= toTake;
                        if (!gp.m_41619_()) continue;
                        FletchingMenu.this.inputSlots.m_6836_(i, ItemStack.f_41583_);
                    }
                } else if (stack.m_150930_(Items.f_42689_)) {
                    ItemStack gp = FletchingMenu.this.inputSlots.m_8020_(0);
                    if (gp.m_150930_(Items.f_42403_)) {
                        gp.m_41774_(1);
                        if (gp.m_41619_()) {
                            FletchingMenu.this.inputSlots.m_6836_(0, ItemStack.f_41583_);
                        }
                    }
                    for (int i = 1; i <= 4; ++i) {
                        boolean valid;
                        ItemStack ing = FletchingMenu.this.inputSlots.m_8020_(i);
                        boolean bl = valid = ing.m_150930_(Items.f_42525_) || ing.m_150930_(Items.f_42415_) || ing.m_150930_(Items.f_42613_) || ing.m_150930_(Items.f_42402_) || ing.m_150930_(Items.f_42587_) || ing.m_41720_().toString().endsWith("_dye") || ing.m_41720_().toString().contains("head");
                        if (!valid) continue;
                        ing.m_41774_(1);
                        if (!ing.m_41619_()) continue;
                        FletchingMenu.this.inputSlots.m_6836_(i, ItemStack.f_41583_);
                    }
                } else {
                    FletchingMenu.this.inputSlots.m_6836_(0, ItemStack.f_41583_);
                    for (int i = 1; i <= 4; ++i) {
                        ItemStack potion = FletchingMenu.this.inputSlots.m_8020_(i);
                        if (potion.m_41619_() || !potion.m_150930_(Items.f_42589_) && !potion.m_150930_(Items.f_42736_) && !potion.m_150930_(Items.f_42739_)) continue;
                        FletchingMenu.this.inputSlots.m_6836_(i, new ItemStack((ItemLike)Items.f_42590_));
                    }
                }
                super.m_142406_(player, stack);
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 142));
        }
    }

    private void updateOutput() {
        int paperCount;
        int batches;
        CompoundTag root;
        ItemStack slot0 = this.inputSlots.m_8020_(0);
        if (slot0.m_150930_(Items.f_42403_)) {
            int starCount = 0;
            ArrayList<Integer> colors = new ArrayList<Integer>();
            ArrayList fades = new ArrayList();
            boolean hasTrail = false;
            boolean hasTwinkle = false;
            int shape = 0;
            for (int i = 1; i <= 4; ++i) {
                ItemStack ing = this.inputSlots.m_8020_(i);
                if (ing.m_41619_()) continue;
                ++starCount;
                String id = ing.m_41720_().toString();
                if (id.endsWith("_dye")) {
                    colors.add(this.getColorFromDye(ing));
                    continue;
                }
                if (ing.m_150930_(Items.f_42525_)) {
                    hasTwinkle = true;
                    continue;
                }
                if (ing.m_150930_(Items.f_42415_)) {
                    hasTrail = true;
                    continue;
                }
                if (ing.m_150930_(Items.f_42613_)) {
                    shape = 1;
                    continue;
                }
                if (ing.m_150930_(Items.f_42587_)) {
                    shape = 2;
                    continue;
                }
                if (id.contains("head")) {
                    shape = 3;
                    continue;
                }
                if (!ing.m_150930_(Items.f_42402_)) continue;
                shape = 4;
            }
            if (starCount > 0) {
                ItemStack star = new ItemStack((ItemLike)Items.f_42689_, Math.min(starCount, 4));
                CompoundTag explosion = new CompoundTag();
                explosion.m_128344_("Type", (byte)shape);
                explosion.m_128379_("Trail", hasTrail);
                explosion.m_128379_("Flicker", hasTwinkle);
                if (!colors.isEmpty()) {
                    explosion.m_128408_("Colors", colors);
                }
                if (!fades.isEmpty()) {
                    explosion.m_128408_("FadeColors", fades);
                }
                root = new CompoundTag();
                root.m_128365_("Explosion", (Tag)explosion);
                star.m_41751_(root);
                star.m_41714_((Component)Component.m_237113_((String)"Firework Star").m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
                this.resultSlot.m_6836_(0, star);
                return;
            }
        }
        boolean isPaper = slot0.m_150930_(Items.f_42516_);
        int gunpowderCount = 0;
        int minGunpowder = Integer.MAX_VALUE;
        ListTag explosions = new ListTag();
        for (int i = 1; i <= 4; ++i) {
            ItemStack item = this.inputSlots.m_8020_(i);
            if (item.m_150930_(Items.f_42403_)) {
                ++gunpowderCount;
                minGunpowder = Math.min(minGunpowder, item.m_41613_());
                continue;
            }
            if (!item.m_150930_(Items.f_42689_) || !item.m_41782_() || !item.m_41783_().m_128441_("Explosion")) continue;
            explosions.add((Object)item.m_41783_().m_128469_("Explosion"));
        }
        if (isPaper && gunpowderCount >= 1 && (batches = Math.min(paperCount = slot0.m_41613_(), minGunpowder)) > 0) {
            ItemStack firework = new ItemStack((ItemLike)Items.f_42688_, batches * 8);
            CompoundTag fireworks = new CompoundTag();
            fireworks.m_128344_("Flight", (byte)Math.min(1 + (gunpowderCount - 1), 4));
            if (!explosions.isEmpty()) {
                fireworks.m_128365_("Explosions", (Tag)explosions);
            }
            root = new CompoundTag();
            root.m_128365_("Fireworks", (Tag)fireworks);
            firework.m_41751_(root);
            firework.m_41714_((Component)Component.m_237113_((String)"Firework Rocket").m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
            this.resultSlot.m_6836_(0, firework);
            return;
        }
        ItemStack arrowStack = this.inputSlots.m_8020_(0);
        if (arrowStack.m_41619_() || !arrowStack.m_150930_(Items.f_42412_) && !arrowStack.m_150930_(Items.f_42738_)) {
            this.resultSlot.m_6836_(0, ItemStack.f_41583_);
            return;
        }
        List inputEffects = PotionUtils.m_43547_((ItemStack)arrowStack);
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
        for (int i = 1; i <= 4; ++i) {
            ItemStack potion = this.inputSlots.m_8020_(i);
            if (potion.m_41619_() || !potion.m_150930_(Items.f_42589_) && !potion.m_150930_(Items.f_42736_) && !potion.m_150930_(Items.f_42739_)) continue;
            List potionEffects = PotionUtils.m_43547_((ItemStack)potion);
            for (MobEffectInstance eff : potionEffects) {
                boolean replaced = false;
                for (int j = 0; j < newEffects.size(); ++j) {
                    MobEffectInstance existing = (MobEffectInstance)newEffects.get(j);
                    if (!existing.m_19544_().equals(eff.m_19544_())) continue;
                    if (eff.m_19564_() > existing.m_19564_() || eff.m_19557_() > existing.m_19557_()) {
                        newEffects.set(j, eff);
                    }
                    replaced = true;
                    break;
                }
                if (replaced) continue;
                newEffects.add(eff);
            }
        }
        if (newEffects.isEmpty()) {
            this.resultSlot.m_6836_(0, ItemStack.f_41583_);
            return;
        }
        ArrayList<MobEffectInstance> merged = new ArrayList<MobEffectInstance>(inputEffects);
        for (MobEffectInstance eff : newEffects) {
            boolean replaced = false;
            for (int j = 0; j < merged.size(); ++j) {
                MobEffectInstance existing = (MobEffectInstance)merged.get(j);
                if (!existing.m_19544_().equals(eff.m_19544_())) continue;
                if (eff.m_19564_() > existing.m_19564_() || eff.m_19557_() > existing.m_19557_()) {
                    merged.set(j, eff);
                }
                replaced = true;
                break;
            }
            if (replaced) continue;
            merged.add(eff);
        }
        ItemStack output = new ItemStack((ItemLike)Items.f_42738_, arrowStack.m_41613_());
        PotionUtils.m_43552_((ItemStack)output, merged);
        PotionUtils.m_43549_((ItemStack)output, (Potion)Potions.f_43598_);
        output.m_41714_((Component)Component.m_237113_((String)"Tipped Arrow").m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
        output.m_41784_().m_128405_("CustomPotionColor", PotionUtils.m_43564_(merged));
        this.resultSlot.m_6836_(0, output);
    }

    private int getColorFromDye(ItemStack dye) {
        String name = dye.m_41720_().toString();
        for (DyeColor c : DyeColor.values()) {
            if (!name.contains(c.m_41065_())) continue;
            return c.m_41070_();
        }
        return 0xFFFFFF;
    }

    private byte getExplosionTypeByte(String shape) {
        return switch (shape) {
            case "large_ball" -> 1;
            case "star" -> 2;
            case "creeper" -> 3;
            case "burst" -> 4;
            default -> 0;
        };
    }

    private ListTag intListToNBT(List<Integer> ints) {
        ListTag tag = new ListTag();
        for (int i : ints) {
            tag.add((Object)IntTag.m_128679_((int)i));
        }
        return tag;
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        if (container == this.inputSlots) {
            this.updateOutput();
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.inputSlots);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack clicked = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            clicked = stack.m_41777_();
            if (index == 5) {
                if (!this.m_38903_(stack, 6, 42, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, clicked);
            } else if (index >= 6) {
                if ((stack.m_150930_(Items.f_42412_) || stack.m_150930_(Items.f_42738_)) && !((Slot)this.f_38839_.get(0)).m_6657_()) {
                    if (!this.m_38903_(stack, 0, 1, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_)) {
                    boolean moved = false;
                    for (int i = 1; i <= 4; ++i) {
                        ItemStack single;
                        if (((Slot)this.f_38839_.get(i)).m_6657_() || (single = stack.m_41620_(1)).m_41619_()) continue;
                        ((Slot)this.f_38839_.get(i)).m_5852_(single);
                        ((Slot)this.f_38839_.get(i)).m_6654_();
                        moved = true;
                        break;
                    }
                    if (!moved) {
                        return ItemStack.f_41583_;
                    }
                } else if (index < 33 ? !this.m_38903_(stack, 33, 42, false) : !this.m_38903_(stack, 6, 33, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(stack, 6, 42, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == clicked.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return clicked;
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

