/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.mcreator.durability.DurabilityModMenuTypes;
import net.mcreator.durability.init.DurabilityModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class GildingTableMenu
extends AbstractContainerMenu {
    public int gildingXpCost = 0;
    private final ContainerLevelAccess access;
    private final Player player;
    private final Container inputSlots = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            GildingTableMenu.this.m_6199_((Container)this);
        }
    };
    private final Container resultSlots = new ResultContainer();

    public GildingTableMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, ContainerLevelAccess.m_39289_((Level)inv.f_35978_.m_9236_(), (BlockPos)buf.m_130135_()));
    }

    public GildingTableMenu(int id, Inventory inv, final ContainerLevelAccess access) {
        super((MenuType)DurabilityModMenuTypes.GILDING_TABLE_MENU.get(), id);
        this.access = access;
        this.player = inv.f_35978_;
        this.m_38897_(new Slot(this.inputSlots, 0, 49, 21));
        this.m_38897_(new Slot(this.inputSlots, 1, 49, 42));
        this.m_38897_(new Slot(this.resultSlots, 2, 129, 34){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                ItemStack gold;
                int cost = stack.m_41784_().m_128451_("GildingXpCost");
                if (!player.m_150110_().f_35937_ && player.f_36078_ < cost) {
                    GildingTableMenu.this.resultSlots.m_6836_(0, ItemStack.f_41583_);
                    return;
                }
                if (!player.m_150110_().f_35937_) {
                    player.m_6749_(-cost);
                }
                if (!(gold = GildingTableMenu.this.inputSlots.m_8020_(1)).m_41619_()) {
                    gold.m_41774_(1);
                    if (gold.m_41619_()) {
                        gold = ItemStack.f_41583_;
                    }
                    GildingTableMenu.this.inputSlots.m_6836_(1, gold);
                }
                GildingTableMenu.this.inputSlots.m_6836_(0, ItemStack.f_41583_);
                access.m_39292_((level, pos) -> level.m_5594_(null, pos, SoundEvents.f_12471_, SoundSource.BLOCKS, 1.0f, 0.8f));
                super.m_142406_(player, stack);
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 142));
        }
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        if (container == this.inputSlots) {
            this.updateResult();
        }
    }

    private void updateResult() {
        ItemStack input = this.inputSlots.m_8020_(0);
        ItemStack gold = this.inputSlots.m_8020_(1);
        this.gildingXpCost = 0;
        if (input.m_41619_() || gold.m_41619_() || !gold.m_150930_(Items.f_42417_)) {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
            return;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)input);
        if (enchantments.isEmpty()) {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
            return;
        }
        int gildCount = input.m_41784_().m_128451_("GildedCount");
        if (gildCount >= 3) {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
            return;
        }
        this.gildingXpCost = 3 * (gildCount + 1);
        if (!this.player.m_150110_().f_35937_ && this.player.f_36078_ < this.gildingXpCost) {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
            return;
        }
        ItemStack result = input.m_41777_();
        ArrayList list = new ArrayList(enchantments.keySet());
        Enchantment chosen = (Enchantment)list.get(new Random().nextInt(list.size()));
        int newLevel = (Integer)enchantments.get(chosen) + 1;
        enchantments.put(chosen, newLevel);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)result);
        result.m_41784_().m_128405_("GildedCount", gildCount + 1);
        result.m_41784_().m_128405_("GildingXpCost", this.gildingXpCost);
        this.resultSlots.m_6836_(0, result);
    }

    public boolean m_6875_(Player player) {
        return GildingTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)DurabilityModBlocks.GILDING_TABLE.get()));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack clicked = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            clicked = stack.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(stack, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, clicked);
            } else if (index >= 3 ? (stack.m_41793_() && !((Slot)this.f_38839_.get(0)).m_6657_() ? !this.m_38903_(stack, 0, 1, false) : (stack.m_150930_(Items.f_42417_) && !((Slot)this.f_38839_.get(1)).m_6657_() ? !this.m_38903_(stack, 1, 2, false) : (index < 30 ? !this.m_38903_(stack, 30, 39, false) : !this.m_38903_(stack, 3, 30, false)))) : !this.m_38903_(stack, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == clicked.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return clicked;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.inputSlots);
    }
}

