/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability;

import java.util.UUID;
import java.util.function.Supplier;
import net.mcreator.durability.DisguiseTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncDisguisePacket {
    private final UUID playerId;
    private final String targetName;

    public SyncDisguisePacket(UUID playerId, String targetName) {
        this.playerId = playerId;
        this.targetName = targetName;
    }

    public static void encode(SyncDisguisePacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerId);
        buf.m_130070_(msg.targetName);
    }

    public static SyncDisguisePacket decode(FriendlyByteBuf buf) {
        return new SyncDisguisePacket(buf.m_130259_(), buf.m_130277_());
    }

    public static void handle(SyncDisguisePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                SyncDisguisePacket.applyClientDisguise(msg.playerId, msg.targetName);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void applyClientDisguise(UUID playerId, String targetName) {
        Minecraft mc = Minecraft.m_91087_();
        Player player = mc.f_91073_.m_46003_(playerId);
        if (player != null) {
            DisguiseTracker.setDisguise(playerId, targetName);
        }
    }
}

