/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BundleItem.class})
public abstract class BundleItemMixin {
    private static final String TIED_KEY = "Tied";

    @Inject(method={"overrideStackedOnOther"}, at={@At(value="HEAD")}, cancellable=true)
    private void blockStackedOnOther(ItemStack bundle, Slot slot, ClickAction action, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (BundleItemMixin.isTied(bundle)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"overrideOtherStackedOnMe"}, at={@At(value="HEAD")}, cancellable=true)
    private void blockOtherStackedOnMe(ItemStack bundle, ItemStack stack, Slot slot, ClickAction action, Player player, SlotAccess slotAccess, CallbackInfoReturnable<Boolean> cir) {
        if (BundleItemMixin.isTied(bundle)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemStack bundle = player.m_21120_(hand);
        ItemStack offhand = player.m_21206_();
        if (BundleItemMixin.isTied(bundle)) {
            if (player.m_6144_() && offhand.m_41720_() instanceof ShearsItem) {
                BundleItemMixin.setTied(bundle, false);
                player.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
                cir.setReturnValue((Object)InteractionResultHolder.m_19090_((Object)bundle));
            } else {
                cir.setReturnValue((Object)InteractionResultHolder.m_19098_((Object)bundle));
            }
            return;
        }
        if (player.m_6144_() && offhand.m_150930_(Items.f_42401_)) {
            BundleItemMixin.setTied(bundle, true);
            if (!player.m_7500_()) {
                offhand.m_41774_(1);
            }
            player.m_5496_(SoundEvents.f_12642_, 1.0f, 1.0f);
            cir.setReturnValue((Object)InteractionResultHolder.m_19090_((Object)bundle));
        }
    }

    @Inject(method={"getTooltipImage"}, at={@At(value="HEAD")}, cancellable=true)
    private void hideTooltipWhenTied(ItemStack stack, CallbackInfoReturnable<Optional<TooltipComponent>> cir) {
        if (BundleItemMixin.isTied(stack)) {
            cir.setReturnValue(Optional.empty());
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="TAIL")})
    private void addTiedTooltip(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag, CallbackInfo ci) {
        if (BundleItemMixin.isTied(stack)) {
            tooltip.add((Component)Component.m_237113_((String)TIED_KEY).m_130940_(ChatFormatting.BLUE));
        }
    }

    private static boolean isTied(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(TIED_KEY);
    }

    private static void setTied(ItemStack stack, boolean tied) {
        stack.m_41784_().m_128379_(TIED_KEY, tied);
    }

    @Inject(method={"getWeight"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fixWeight(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        int maxStack = stack.m_41741_();
        if (maxStack == 1) {
            cir.setReturnValue((Object)8);
        } else {
            cir.setReturnValue((Object)(64 / maxStack));
        }
    }
}

