/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import net.mcreator.durability.DurabilityConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public class EnchantmentCategoryWeaponMixin {
    @Inject(method={"canEnchant"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void allowWeaponsOnDiggers(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)DurabilityConfig.COMMON.weaponEnchTools.get()).booleanValue()) {
            return;
        }
        Enchantment self = (Enchantment)this;
        if (self.f_44672_ == EnchantmentCategory.WEAPON && stack.m_41720_() instanceof DiggerItem) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getFullname"}, at={@At(value="HEAD")}, cancellable=true)
    private void durability$fixRomanLevels(int level, CallbackInfoReturnable<Component> cir) {
        Enchantment self = (Enchantment)this;
        MutableComponent name = Component.m_237115_((String)self.m_44704_());
        if (self.m_6589_()) {
            name.m_130940_(ChatFormatting.RED);
        } else {
            name.m_130940_(ChatFormatting.GRAY);
        }
        if (level != 1 || self.m_6586_() != 1) {
            name.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237113_((String)EnchantmentCategoryWeaponMixin.toRoman(level)));
        }
        cir.setReturnValue((Object)name);
    }

    private static String toRoman(int number) {
        if (number <= 0) {
            return "";
        }
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] numerals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (number >= values[i]) {
                number -= values[i];
                result.append(numerals[i]);
            }
        }
        return result.toString();
    }
}

