/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.durability.init.DurabilityModEnchantments;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class HumanoidArmorLayerMixin<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>> {
    @Inject(method={"renderArmorPiece"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArmorPiece(PoseStack poseStack, MultiBufferSource buffer, T entity, EquipmentSlot slot, int packedLight, A model, CallbackInfo ci) {
        Item item;
        ItemStack stack = entity.m_6844_(slot);
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DurabilityModEnchantments.OPACITY.get()), (ItemStack)stack);
        if (level <= 0 || !((item = stack.m_41720_()) instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        float alpha = 1.0f - 0.25f * (float)level;
        if (alpha <= 0.0f) {
            ci.cancel();
            return;
        }
        ci.cancel();
        ((HumanoidModel)((HumanoidArmorLayer)this).m_117386_()).m_102872_(model);
        this.applyOpacityVisibility(model, slot);
        ResourceLocation armorTexture = ((HumanoidArmorLayer)this).getArmorResource(entity, stack, slot, null);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)armorTexture));
        model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
    }

    private void applyOpacityVisibility(A model, EquipmentSlot slot) {
        model.m_8009_(false);
        switch (slot) {
            case HEAD: {
                ((HumanoidModel)model).f_102808_.f_104207_ = true;
                ((HumanoidModel)model).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)model).f_102810_.f_104207_ = true;
                ((HumanoidModel)model).f_102811_.f_104207_ = true;
                ((HumanoidModel)model).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)model).f_102810_.f_104207_ = true;
                ((HumanoidModel)model).f_102813_.f_104207_ = true;
                ((HumanoidModel)model).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)model).f_102813_.f_104207_ = true;
                ((HumanoidModel)model).f_102814_.f_104207_ = true;
            }
        }
    }
}

