/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import net.mcreator.durability.DurabilityClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemBarMixin {
    private static final TagKey<Item> STACKABLES_16 = ItemTags.create((ResourceLocation)new ResourceLocation("durability", "stackables_16"));

    private boolean isPlayerInventoryContext() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91080_ == null || mc.f_91080_ instanceof InventoryScreen;
    }

    @Inject(method={"isFoil"}, at={@At(value="HEAD")}, cancellable=true)
    private void overlain$forceFoil(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128471_("CustomGlint")) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isBarVisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void alwaysShowBar(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.m_150930_(Items.f_42690_)) {
            return;
        }
        if (this.isShulkerBox(stack)) {
            cir.setReturnValue((Object)(this.getShulkerFullness(stack) > 0.0f ? 1 : 0));
            return;
        }
        if (!this.isPlayerInventoryContext()) {
            return;
        }
        int max = this.getCustomStackLimit(stack);
        if (max > 1) {
            if (Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen) {
                cir.setReturnValue((Object)false);
                return;
            }
            cir.setReturnValue((Object)((Boolean)DurabilityClientConfig.DO_DURABILITY_STACK.get()));
        }
    }

    @Inject(method={"getBarWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void customBarWidth(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (stack.m_150930_(Items.f_42690_)) {
            return;
        }
        if (this.isShulkerBox(stack)) {
            float fullness = this.getShulkerFullness(stack);
            cir.setReturnValue((Object)Math.round(13.0f * fullness));
            return;
        }
        int max = this.getCustomStackLimit(stack);
        if (max > 1) {
            int countInGroup = (stack.m_41613_() - 1) % max + 1;
            float fullness = (float)countInGroup / (float)max;
            cir.setReturnValue((Object)Math.round(13.0f * fullness));
        }
    }

    @Inject(method={"getBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void customBarColor(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        BlockItem blockItem;
        Block block;
        if (stack.m_150930_(Items.f_42690_)) {
            return;
        }
        if (this.isShulkerBox(stack) && (block = (blockItem = (BlockItem)stack.m_41720_()).m_40614_()) instanceof ShulkerBoxBlock) {
            ShulkerBoxBlock shulker = (ShulkerBoxBlock)block;
            if (shulker.m_56261_() != null) {
                cir.setReturnValue((Object)shulker.m_56261_().m_41071_());
            } else {
                cir.setReturnValue((Object)0x800080);
            }
            return;
        }
        int max = this.getCustomStackLimit(stack);
        if (max > 1) {
            int countInGroup = (stack.m_41613_() - 1) % max + 1;
            float fullness = (float)countInGroup / (float)max;
            int gray = (int)(255.0f * fullness);
            int color = gray << 16 | gray << 8 | gray;
            cir.setReturnValue((Object)color);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getEnchantmentValue"}, cancellable=true)
    private void init(CallbackInfoReturnable<Integer> cir) {
        if (this instanceof HorseArmorItem) {
            cir.setReturnValue((Object)1);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isEnchantable"}, cancellable=true)
    private void init(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof HorseArmorItem) {
            cir.setReturnValue((Object)true);
        }
    }

    private boolean isShulkerBox(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock;
    }

    private float getShulkerFullness(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag == null || !tag.m_128441_("Items")) {
            return 0.0f;
        }
        ListTag items = tag.m_128437_("Items", 10);
        int filledSlots = 0;
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag itemTag = items.m_128728_(i);
            ItemStack inside = ItemStack.m_41712_((CompoundTag)itemTag);
            if (inside.m_41619_()) continue;
            ++filledSlots;
        }
        return (float)filledSlots / 27.0f;
    }

    private int getCustomStackLimit(ItemStack stack) {
        if (stack.m_150930_(Items.f_42690_)) {
            return 4;
        }
        if (stack.m_204117_(STACKABLES_16)) {
            return 16;
        }
        int vanilla = stack.m_41720_().m_41459_();
        if (vanilla > 1 && vanilla < 64) {
            return 64;
        }
        return vanilla;
    }
}

