/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.durability.DurabilityClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class ItemRendererMixin {
    private static final TagKey<Item> STACKABLES_16 = ItemTags.create((ResourceLocation)new ResourceLocation("durability", "stackables_16"));
    private static final TagKey<Item> STACKABLES_4 = ItemTags.create((ResourceLocation)new ResourceLocation("durability", "stackables_4"));

    private boolean isPlayerInventoryContext() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91080_ == null || mc.f_91080_ instanceof InventoryScreen;
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")})
    private void renderCustomOverflowLabel(Font font, ItemStack stack, int x, int y, String text, CallbackInfo ci) {
        int stackNumber;
        if (Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen) {
            return;
        }
        if (!((Boolean)DurabilityClientConfig.DO_DURABILITY_STACK.get()).booleanValue()) {
            return;
        }
        if (!this.isPlayerInventoryContext()) {
            return;
        }
        if (stack.m_204117_(STACKABLES_16)) {
            int stackNumber2 = (stack.m_41613_() - 1) / 16;
            if (stackNumber2 > 0) {
                String s = String.valueOf(stackNumber2);
                PoseStack pose = ((GuiGraphics)this).m_280168_();
                pose.m_85836_();
                pose.m_252880_(0.0f, 0.0f, 200.0f);
                ((GuiGraphics)this).m_280056_(font, s, x + 1, y + 1, 0xFFFFFF, true);
                pose.m_85849_();
            }
            return;
        }
        if (stack.m_204117_(STACKABLES_4)) {
            int stackNumber3 = (stack.m_41613_() - 1) / 4;
            if (stackNumber3 > 0) {
                String s = String.valueOf(stackNumber3);
                PoseStack pose = ((GuiGraphics)this).m_280168_();
                pose.m_85836_();
                pose.m_252880_(0.0f, 0.0f, 200.0f);
                ((GuiGraphics)this).m_280056_(font, s, x + 1, y + 1, 0xFFFFFF, true);
                pose.m_85849_();
            }
            return;
        }
        int vanillaMax = stack.m_41720_().m_41459_();
        if (vanillaMax > 1 && (stackNumber = (stack.m_41613_() - 1) / 64) > 0) {
            String s = String.valueOf(stackNumber);
            PoseStack pose = ((GuiGraphics)this).m_280168_();
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 200.0f);
            ((GuiGraphics)this).m_280056_(font, s, x + 1, y + 1, 0xFFFFFF, true);
            pose.m_85849_();
        }
    }

    @ModifyVariable(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private String hideVanillaCount(String originalText, Font font, ItemStack stack, int x, int y, String text) {
        if (!((Boolean)DurabilityClientConfig.DO_DURABILITY_STACK.get()).booleanValue()) {
            return originalText;
        }
        if (Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen) {
            return originalText;
        }
        if (!this.isPlayerInventoryContext()) {
            return originalText;
        }
        if (stack.m_41763_()) {
            return "";
        }
        if (stack.m_204117_(STACKABLES_16)) {
            return "";
        }
        if (stack.m_204117_(STACKABLES_4)) {
            return "";
        }
        if (stack.m_41720_().m_41459_() > 1) {
            return "";
        }
        return originalText;
    }
}

