/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import net.mcreator.durability.DurabilityConfig;
import net.mcreator.durability.init.DurabilityModEnchantments;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    private static final TagKey<Item> STACKABLES_16 = ItemTags.create((ResourceLocation)new ResourceLocation("durability", "stackables_16"));
    private static final TagKey<Item> STACKABLES_4 = ItemTags.create((ResourceLocation)new ResourceLocation("durability", "stackables_4"));

    @Inject(method={"getMaxStackSize"}, at={@At(value="HEAD")}, cancellable=true)
    private void customStackSizes(CallbackInfoReturnable<Integer> cir) {
        if (!((Boolean)DurabilityConfig.COMMON.enableItemStackIncrease.get()).booleanValue()) {
            return;
        }
        ItemStack self = (ItemStack)this;
        if (self.m_204117_(STACKABLES_4)) {
            cir.setReturnValue((Object)4);
            return;
        }
        if (self.m_204117_(STACKABLES_16)) {
            cir.setReturnValue((Object)16);
            return;
        }
        int vanilla = self.m_41720_().m_41459_();
        if (vanilla > 1 && vanilla < 64) {
            cir.setReturnValue((Object)64);
        }
    }

    @Inject(method={"isFoil"}, at={@At(value="HEAD")}, cancellable=true)
    private void overlain$customFoil(CallbackInfoReturnable<Boolean> cir) {
        ItemStack self = (ItemStack)this;
        CompoundTag tag = self.m_41783_();
        if (tag != null && tag.m_128471_("CustomGlint")) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private int increaseDurabilityDamage(int amount, int originalAmount, LivingEntity entity, Consumer<LivingEntity> onBroken) {
        ItemStack self = (ItemStack)this;
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DurabilityModEnchantments.BREAKING.get()), (ItemStack)self);
        if (level > 0) {
            return amount * (level + 1);
        }
        return amount;
    }

    @Inject(method={"getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableAttributesWithVoiding(EquipmentSlot slot, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> cir) {
        ItemStack self = (ItemStack)this;
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DurabilityModEnchantments.VOIDING.get()), (ItemStack)self);
        if (level > 0) {
            cir.setReturnValue((Object)HashMultimap.create());
        }
    }

    @Inject(method={"getRarity"}, at={@At(value="HEAD")}, cancellable=true)
    private void customBookRarity(CallbackInfoReturnable<Rarity> cir) {
        CompoundTag tag;
        ResourceLocation id;
        Enchantment enchantment;
        ListTag listtag;
        if (!((Boolean)DurabilityConfig.COMMON.enableBookRarity.get()).booleanValue()) {
            return;
        }
        ItemStack stack = (ItemStack)this;
        if (stack.m_41720_() instanceof EnchantedBookItem && (listtag = EnchantedBookItem.m_41163_((ItemStack)stack)).size() == 1 && (enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(id = EnchantmentHelper.m_182446_((CompoundTag)(tag = listtag.m_128728_(0))))) != null) {
            switch (enchantment.m_44699_()) {
                case COMMON: {
                    cir.setReturnValue((Object)Rarity.COMMON);
                    break;
                }
                case UNCOMMON: {
                    cir.setReturnValue((Object)Rarity.UNCOMMON);
                    break;
                }
                case RARE: {
                    cir.setReturnValue((Object)Rarity.RARE);
                    break;
                }
                case VERY_RARE: {
                    cir.setReturnValue((Object)Rarity.EPIC);
                }
            }
        }
    }
}

