/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import net.mcreator.durability.DurabilityConfig;
import net.mcreator.durability.init.DurabilityModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityBlockMixin {
    private static final ThreadLocal<Boolean> BLOCKING_DAMAGE = ThreadLocal.withInitial(() -> false);

    @Shadow
    public abstract ItemStack m_21211_();

    @Shadow
    public abstract boolean m_6117_();

    @Shadow
    public abstract int m_21212_();

    @Shadow
    public abstract InteractionHand m_7655_();

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Item item;
        if (!((Boolean)DurabilityConfig.COMMON.swordBlocking.get()).booleanValue()) {
            return;
        }
        if (BLOCKING_DAMAGE.get().booleanValue()) {
            return;
        }
        LivingEntity self = (LivingEntity)this;
        ItemStack stack = self.m_21211_();
        if (self.m_6117_() && (item = stack.m_41720_()) instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            Entity attacker = source.m_7639_();
            float half = amount * 0.5f;
            if (self instanceof Player) {
                Player player = (Player)self;
                player.m_36335_().m_41524_(stack.m_41720_(), 10);
            }
            stack.m_41622_(3, self, e -> e.m_21190_(self.m_7655_()));
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                BLOCKING_DAMAGE.set(true);
                livingAttacker.m_6469_(self.m_269291_().m_269374_((Entity)self), half);
                BLOCKING_DAMAGE.set(false);
            }
            BLOCKING_DAMAGE.set(true);
            boolean result = self.m_6469_(source, half);
            BLOCKING_DAMAGE.set(false);
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"knockback"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelKnockback(double strength, double x, double z, CallbackInfo ci) {
        if (!((Boolean)DurabilityConfig.COMMON.swordBlocking.get()).booleanValue()) {
            return;
        }
        LivingEntity self = (LivingEntity)this;
        ItemStack stack = self.m_21211_();
        if (self.m_6117_() && stack.m_41720_() instanceof SwordItem) {
            ci.cancel();
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void removeIFramesForProjectiles(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)DurabilityConfig.COMMON.projectileIFrames.get()).booleanValue()) {
            return;
        }
        LivingEntity self = (LivingEntity)this;
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            self.f_19802_ = 0;
        }
    }

    @Inject(method={"getDisplayName"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideDisplayName(CallbackInfoReturnable<Component> cir) {
        Player player;
        LivingEntity self = (LivingEntity)this;
        if (self instanceof Player && (player = (Player)self).m_6844_(EquipmentSlot.HEAD).m_150930_((Item)DurabilityModItems.CLOAK_HELMET.get())) {
            cir.setReturnValue((Object)Component.m_237113_((String)"???"));
        }
    }
}

