/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import net.mcreator.durability.DurabilityConfig;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={SmithingTemplateItem.class})
public abstract class SmithingTemplateItemMixin
extends Item {
    public SmithingTemplateItemMixin(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return (Boolean)DurabilityConfig.COMMON.enableTemplateDurability.get();
    }

    public int m_142159_(ItemStack stack) {
        if (!((Boolean)DurabilityConfig.COMMON.enableTemplateDurability.get()).booleanValue()) {
            return super.m_142159_(stack);
        }
        float durability = (float)stack.m_41773_() / (float)stack.m_41776_();
        return this.getGradientColor(durability, 4910553, 2147765, 0x1AAAA7, 1872282);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repairCandidate) {
        if (!((Boolean)DurabilityConfig.COMMON.enableTemplateDurability.get()).booleanValue()) {
            return false;
        }
        return repairCandidate.m_150930_(Items.f_42415_) || super.m_6832_(toRepair, repairCandidate);
    }

    private int getGradientColor(float progress, int ... colors) {
        if (colors.length == 1) {
            return colors[0];
        }
        float scaled = progress * (float)(colors.length - 1);
        int index = Math.min((int)scaled, colors.length - 2);
        float t = scaled - (float)index;
        return this.lerpColor(colors[index], colors[index + 1], t);
    }

    private int lerpColor(int c1, int c2, float t) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;<init>(Lnet/minecraft/world/item/Item$Properties;)V"), index=0)
    private static Item.Properties patchSmithingTemplateDurability(Item.Properties original) {
        return original.m_41503_(4);
    }
}

