/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import net.mcreator.durability.mixins.AnvilMenuAccessorMixin;
import net.mcreator.durability.mixins.AnvilMenuRepairAccessorMixin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin {
    @Inject(method={"createResult"}, at={@At(value="TAIL")})
    private void durability$adjustCosts(CallbackInfo ci) {
        boolean isBook;
        AnvilMenu self = (AnvilMenu)this;
        AnvilMenuAccessorMixin accessor = (AnvilMenuAccessorMixin)self;
        ItemStack left = accessor.getInputSlots().m_8020_(0);
        ItemStack right = accessor.getInputSlots().m_8020_(1);
        ItemStack result = accessor.getResultSlots().m_8020_(0);
        if (result.m_41619_()) {
            return;
        }
        int originalCost = self.m_39028_();
        boolean bl = isBook = right.m_41720_() == Items.f_42690_ && !EnchantedBookItem.m_41163_((ItemStack)right).isEmpty();
        if (!right.m_41619_() && left.m_41763_() && left.m_41720_().m_6832_(left, right)) {
            self.setMaximumCost(0);
            ((AnvilMenuRepairAccessorMixin)self).setRepairItemCountCost(0);
            return;
        }
        if (!right.m_41619_() && left.m_41763_() && left.m_41720_() == right.m_41720_()) {
            boolean rightHasEnchants;
            boolean leftHasEnchants = !left.m_41785_().isEmpty();
            boolean bl2 = rightHasEnchants = !right.m_41785_().isEmpty();
            if (!leftHasEnchants && !rightHasEnchants) {
                self.setMaximumCost(0);
                ((AnvilMenuRepairAccessorMixin)self).setRepairItemCountCost(0);
                return;
            }
            int repairCount = ((AnvilMenuRepairAccessorMixin)self).getRepairItemCountCost();
            if (originalCost > 0) {
                int newCost = Math.max(1, originalCost - repairCount);
                self.setMaximumCost(newCost);
                ((AnvilMenuRepairAccessorMixin)self).setRepairItemCountCost(0);
            }
        }
        if (right.m_41619_() && originalCost == 1 && !left.m_41619_() && result.m_41788_()) {
            self.setMaximumCost(0);
            return;
        }
        if (isBook || left.m_41793_() || right.m_41793_()) {
            int cost = self.m_39028_();
            if (cost > 30) {
                cost = 30;
            }
            if (cost < 1) {
                cost = 1;
            }
            self.setMaximumCost(cost);
            if (isBook) {
                ((AnvilMenuRepairAccessorMixin)self).setRepairItemCountCost(1);
            }
        }
    }

    @Inject(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/DataSlot;get()I", ordinal=0, shift=At.Shift.BEFORE)})
    private void durability$preventTooExpensive(CallbackInfo ci) {
        AnvilMenu self = (AnvilMenu)this;
        if (self.m_39028_() > 30) {
            self.setMaximumCost(30);
        }
    }

    @Redirect(method={"onTake"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;giveExperienceLevels(I)V"))
    private void durability$redirectXp(Player player, int amount) {
        if (!player.m_150110_().f_35937_ && amount < 0) {
            int realCost = Math.max(1, (int)Math.ceil((double)(-amount) * 0.1));
            player.m_6749_(-realCost);
        } else {
            player.m_6749_(amount);
        }
    }

    @Inject(method={"mayPickup"}, at={@At(value="HEAD")}, cancellable=true)
    private void durability$allowFreePickup(Player player, boolean hasStack, CallbackInfoReturnable<Boolean> cir) {
        AnvilMenu self = (AnvilMenu)this;
        AnvilMenuAccessorMixin accessor = (AnvilMenuAccessorMixin)self;
        ItemStack out = accessor.getResultSlots().m_8020_(0);
        if (self.m_39028_() == 0 && !out.m_41619_()) {
            cir.setReturnValue((Object)true);
        }
    }
}

