/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.durability.mixins;

import com.mojang.authlib.GameProfile;
import net.mcreator.durability.DisguiseData;
import net.mcreator.durability.DisguiseManager;
import net.mcreator.durability.DisguiseTracker;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class SkinOverrideMixin
extends Player {
    public SkinOverrideMixin(Level world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(method={"getSkinTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectCustomSkin(CallbackInfoReturnable<ResourceLocation> cir) {
        DisguiseData data;
        Player self = this;
        String targetName = DisguiseTracker.getDisguise(self.m_20148_());
        if (targetName != null && (data = DisguiseManager.getSkinForUsername(targetName)) != null) {
            cir.setReturnValue((Object)data.texture);
        }
    }

    @Inject(method={"getModelName"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectCustomModelName(CallbackInfoReturnable<String> cir) {
        DisguiseData data;
        Player self = this;
        String targetName = DisguiseTracker.getDisguise(self.m_20148_());
        if (targetName != null && (data = DisguiseManager.getSkinForUsername(targetName)) != null) {
            cir.setReturnValue((Object)(data.slim ? "slim" : "default"));
        }
    }
}

