/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.Chicken100;

import org.bukkit.entity.Chicken;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class Chicken100
extends JavaPlugin
implements Listener {
    private double chickenSpawnChance;
    private boolean enableParticles;
    private boolean enableSounds;
    private boolean notifyPlayer;
    private int minChickens;
    private int maxChickens;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getLogger().info("Chicken100 has been enabled! Eggs have a " + this.chickenSpawnChance + "% chance to spawn chickens.");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("Chicken100 has been disabled.");
    }

    private void loadConfiguration() {
        this.reloadConfig();
        this.chickenSpawnChance = this.getConfig().getDouble("chicken-spawn-chance", 100.0);
        this.enableParticles = this.getConfig().getBoolean("enable-particles", true);
        this.enableSounds = this.getConfig().getBoolean("enable-sounds", true);
        this.notifyPlayer = this.getConfig().getBoolean("notify-player", true);
        this.minChickens = this.getConfig().getInt("min-chickens", 1);
        this.maxChickens = this.getConfig().getInt("max-chickens", 3);
        if (this.chickenSpawnChance < 0.0) {
            this.chickenSpawnChance = 0.0;
        }
        if (this.chickenSpawnChance > 100.0) {
            this.chickenSpawnChance = 100.0;
        }
        if (this.minChickens < 1) {
            this.minChickens = 1;
        }
        if (this.maxChickens < this.minChickens) {
            this.maxChickens = this.minChickens;
        }
    }

    @EventHandler
    public void onEggThrow(ProjectileLaunchEvent event) {
        if (!(event.getEntity() instanceof Egg)) {
            return;
        }
        final Egg egg = (Egg)event.getEntity();
        final ProjectileSource shooter = egg.getShooter();
        new BukkitRunnable(this){
            final /* synthetic */ Chicken100 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (egg.isDead() || egg.isOnGround()) {
                    this.this$0.handleEggLand(egg, shooter);
                    this.cancel();
                }
            }
        }.runTaskTimer(this, 1L, 1L);
    }

    private void handleEggLand(Egg egg, ProjectileSource shooter) {
        if (Math.random() * 100.0 <= this.chickenSpawnChance) {
            int chickensToSpawn = this.minChickens;
            if (this.maxChickens > this.minChickens) {
                chickensToSpawn += (int)(Math.random() * (double)(this.maxChickens - this.minChickens + 1));
            }
            for (int i = 0; i < chickensToSpawn; ++i) {
                Chicken chicken = (Chicken)egg.getWorld().spawnEntity(egg.getLocation(), EntityType.CHICKEN);
                if (!(Math.random() < 0.1)) continue;
                chicken.setBaby();
            }
            if (shooter instanceof Player && this.notifyPlayer) {
                Player player = (Player)shooter;
                player.sendMessage("\u00a7a\u00a7l\u00bb \u00a7rYour egg spawned \u00a7b" + chickensToSpawn + " \u00a7rchickens!");
            }
            if (this.enableParticles) {
                // empty if block
            }
            if (this.enableSounds) {
                egg.getWorld().playSound(egg.getLocation(), "entity.chicken.ambient", 1.0f, 1.0f);
            }
        }
    }
}

