/*
 * Decompiled with CFR 0.152.
 */
package shiny.weightless;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import shiny.weightless.client.sound.WeightlessFlyingSoundInstance;
import shiny.weightless.common.component.WeightlessComponent;

public class FlyingPlayerTracker {
    private static final Map<UUID, class_3545<class_243, class_243>> trackedVelocities = new HashMap<UUID, class_3545<class_243, class_243>>();
    private static final Map<UUID, WeightlessFlyingSoundInstance> trackedSounds = new HashMap<UUID, WeightlessFlyingSoundInstance>();

    public static void update(class_310 client) {
        FlyingPlayerTracker.updateTrackedVelocity(client);
        FlyingPlayerTracker.updateTrackedSounds(client);
    }

    public static void updateTrackedVelocity(class_310 client) {
        for (class_1657 player : client.field_1687.method_18456()) {
            if (player == client.field_1724) continue;
            if (!FlyingPlayerTracker.trackingVelocity(player)) {
                FlyingPlayerTracker.startTrackingVelocity(player);
                continue;
            }
            FlyingPlayerTracker.updateVelocity(player);
        }
    }

    public static boolean trackingVelocity(class_1657 player) {
        return trackedVelocities.containsKey(player.method_5667());
    }

    public static void startTrackingVelocity(class_1657 player) {
        class_243 velocity = new class_243(player.method_23317() - player.field_6014, player.method_23318() - player.field_6036, player.method_23321() - player.field_5969);
        trackedVelocities.putIfAbsent(player.method_5667(), (class_3545<class_243, class_243>)new class_3545((Object)class_243.field_1353, (Object)velocity));
    }

    public static void updateVelocity(class_1657 player) {
        class_3545<class_243, class_243> velocities = trackedVelocities.get(player.method_5667());
        if (velocities != null) {
            class_243 velocity = new class_243(player.method_23317() - player.field_6014, player.method_23318() - player.field_6036, player.method_23321() - player.field_5969);
            velocities.method_34964((Object)((class_243)velocities.method_15441()));
            velocity = ((class_243)velocities.method_15442()).method_1021(0.8).method_1019(velocity.method_1021(0.2));
            velocities.method_34965((Object)velocity);
        }
    }

    public static class_243 getVelocity(class_1657 player) {
        class_3545<class_243, class_243> velocities = trackedVelocities.get(player.method_5667());
        if (velocities != null) {
            return (class_243)velocities.method_15441();
        }
        return class_243.field_1353;
    }

    public static class_243 getLerpedVelocity(class_1657 player, float tickDelta) {
        class_3545<class_243, class_243> velocities = trackedVelocities.get(player.method_5667());
        if (velocities != null) {
            return ((class_243)velocities.method_15442()).method_35590((class_243)velocities.method_15441(), (double)tickDelta);
        }
        return class_243.field_1353;
    }

    public static void updateTrackedSounds(class_310 client) {
        for (class_1657 player : client.field_1687.method_18456()) {
            boolean bl;
            if (player == client.field_1724) continue;
            boolean bl2 = bl = WeightlessComponent.flying(player) && (player.method_5624() || WeightlessComponent.autopilot(player));
            if (FlyingPlayerTracker.trackingSound(player) || !bl) continue;
            WeightlessFlyingSoundInstance sound = new WeightlessFlyingSoundInstance(player, player == client.field_1724);
            FlyingPlayerTracker.startTrackingSound(client, player, sound);
        }
    }

    public static boolean trackingSound(class_1657 player) {
        return trackedSounds.containsKey(player.method_5667());
    }

    public static void startTrackingSound(class_310 client, class_1657 source, WeightlessFlyingSoundInstance sound) {
        FlyingPlayerTracker.stopExistingSound(source);
        trackedSounds.putIfAbsent(source.method_5667(), sound);
        client.method_1483().method_4873((class_1113)sound);
    }

    public static void stopExistingSound(class_1657 source) {
        UUID uuid = source.method_5667();
        if (trackedSounds.containsKey(uuid)) {
            class_310 client = class_310.method_1551();
            client.method_1483().method_4870((class_1113)trackedSounds.get(uuid));
            FlyingPlayerTracker.remove(uuid);
        }
    }

    public static void remove(UUID uuid) {
        trackedSounds.remove(uuid);
    }
}

