/*
 * Decompiled with CFR 0.152.
 */
package shiny.weightless;

import ladysnake.satin.api.event.ShaderEffectRenderCallback;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import ladysnake.satin.api.managed.uniform.Uniform1f;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_7923;
import shiny.weightless.FlyingPlayerTracker;
import shiny.weightless.ModConfig;
import shiny.weightless.Weightless;
import shiny.weightless.client.particle.ColorParticleEffect;
import shiny.weightless.client.particle.PointParticle;
import shiny.weightless.client.particle.ShockwaveParticle;
import shiny.weightless.client.sound.WeightlessFlyingSoundInstance;
import shiny.weightless.common.component.WeightlessComponent;

public class WeightlessClient
implements ClientModInitializer {
    public static final class_2400 SHOCKWAVE = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Weightless.id("shockwave"), (Object)FabricParticleTypes.simple());
    public static final class_2396<ColorParticleEffect> POINT = (class_2396)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Weightless.id("point"), (Object)FabricParticleTypes.complex((boolean)true, ColorParticleEffect.PARAMETERS_FACTORY));
    public static final ManagedShaderEffect SPEED_LINES = ShaderEffectManager.getInstance().manage(Weightless.id("shaders/post/speed_lines.json"));
    public static final Uniform1f WORLD_TIME = SPEED_LINES.findUniform1f("WorldTime");
    public static final Uniform1f FLY_SPEED = SPEED_LINES.findUniform1f("FlySpeed");
    private static long worldTime = 0L;
    private static float flySpeed = 0.0f;
    private static boolean flying = false;
    public static class_304 TOGGLE_WEIGHTLESS = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybind.weightless.toggle", class_3675.field_16237.method_1444(), "key.categories.weightless"));
    public static class_304 AUTOPILOT = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybind.weightless.autopilot", class_3675.field_16237.method_1444(), "key.categories.weightless"));
    public static boolean wasWeightlessPressed = false;
    public static boolean wasAutopilotPressed = false;
    public static boolean weightlessActive = true;
    public static boolean autopilotActive = false;
    public static final class_2561 DISCONNECT_MESSAGE = class_2561.method_43471((String)"message.weightless.disconnect");

    public void onInitializeClient() {
        ParticleFactoryRegistry.getInstance().register((class_2396)SHOCKWAVE, ShockwaveParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(POINT, PointParticle.Factory::new);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Weightless.FLYING_SOUND_S2C_PACKET, (client, handler, buf, sender) -> {
            int id;
            class_1297 entity;
            if (client.field_1687 != null && client.field_1724 != null && (entity = client.field_1687.method_8469(id = buf.method_10816())) instanceof class_1657) {
                class_1657 player;
                WeightlessFlyingSoundInstance sound = new WeightlessFlyingSoundInstance(player, (player = (class_1657)entity) == client.field_1724);
                FlyingPlayerTracker.startTrackingSound(client, player, sound);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Weightless.COMPARE_CONFIG_MATCH_S2C_PACKET, (client, handler, buf, sender) -> {
            int encoded = buf.method_10816();
            if (encoded != ModConfig.encode()) {
                handler.method_48296().method_10747(DISCONNECT_MESSAGE);
            }
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (TOGGLE_WEIGHTLESS.method_1434() && !wasWeightlessPressed) {
                weightlessActive = !weightlessActive;
                wasWeightlessPressed = true;
                TOGGLE_WEIGHTLESS.method_23481(false);
            } else if (wasWeightlessPressed) {
                wasWeightlessPressed = false;
            }
            if (AUTOPILOT.method_1434() && !wasAutopilotPressed) {
                autopilotActive = !autopilotActive;
                wasAutopilotPressed = true;
                AUTOPILOT.method_23481(false);
            } else if (wasAutopilotPressed) {
                wasAutopilotPressed = false;
            }
            WeightlessComponent.clientTick(client);
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                boolean bl = client.field_1724.method_5624() || autopilotActive;
                flying = WeightlessComponent.flying((class_1657)client.field_1724) && bl;
                flySpeed = (float)Math.min(client.field_1724.method_18798().method_1027(), 1.0);
            }
            if (client.field_1687 != null) {
                worldTime = client.field_1687.method_8510();
                FlyingPlayerTracker.update(client);
            }
        });
        ShaderEffectRenderCallback.EVENT.register(tickDelta -> {
            if (flying && ModConfig.renderSpeedlines) {
                WORLD_TIME.set((float)worldTime + tickDelta);
                FLY_SPEED.set(flySpeed);
                SPEED_LINES.render(tickDelta);
            }
        });
    }
}

