/*
 * Decompiled with CFR 0.152.
 */
package shiny.weightless.common.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.awt.Color;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import shiny.weightless.ModComponents;
import shiny.weightless.ModConfig;
import shiny.weightless.Weightless;
import shiny.weightless.WeightlessClient;
import shiny.weightless.client.trail.Trail;

public class WeightlessComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 provider;
    private final Trail trail = new Trail(20);
    private int remainingStunTicks;
    private boolean enabled;
    private boolean flying;
    private boolean toggled = true;
    private boolean autopilot = false;
    private int trailRed = 255;
    private int trailGreen = 255;
    private int trailBlue = 255;

    public WeightlessComponent(class_1657 provider) {
        this.provider = provider;
    }

    public static WeightlessComponent get(@NotNull class_1657 player) {
        return (WeightlessComponent)ModComponents.WEIGHTLESS.get((Object)player);
    }

    public static boolean has(@NotNull class_1657 player) {
        return ((WeightlessComponent)ModComponents.WEIGHTLESS.get((Object)player)).has();
    }

    public static boolean flying(@NotNull class_1657 player) {
        return ((WeightlessComponent)ModComponents.WEIGHTLESS.get((Object)player)).flying();
    }

    public static boolean autopilot(@NotNull class_1657 player) {
        return ((WeightlessComponent)ModComponents.WEIGHTLESS.get((Object)player)).autopilot();
    }

    public void sync() {
        ModComponents.WEIGHTLESS.sync((Object)this.provider);
    }

    public static void clientTick(class_310 client) {
        ModComponents.WEIGHTLESS.maybeGet((Object)client.field_1724).ifPresent(component -> {
            class_2540 buf;
            boolean toggled = WeightlessClient.weightlessActive;
            boolean autopilot = WeightlessClient.autopilotActive;
            if (component.toggled != toggled) {
                buf = PacketByteBufs.create();
                buf.writeBoolean(toggled);
                ClientPlayNetworking.send((class_2960)Weightless.WEIGHTLESS_TOGGLE_C2S_PACKET, (class_2540)buf);
                component.toggled = toggled;
            }
            if (component.autopilot != autopilot) {
                buf = PacketByteBufs.create();
                buf.writeBoolean(autopilot);
                ClientPlayNetworking.send((class_2960)Weightless.AUTOPILOT_TOGGLE_C2S_PACKET, (class_2540)buf);
                component.autopilot = autopilot;
            }
            if (!client.method_1493()) {
                int red = ModConfig.trailRed;
                int green = ModConfig.trailGreen;
                int blue = ModConfig.trailBlue;
                if (component.trailRed != red || component.trailGreen != green || component.trailBlue != blue) {
                    class_2540 buf2 = PacketByteBufs.create();
                    buf2.writeInt(red);
                    buf2.writeInt(green);
                    buf2.writeInt(blue);
                    ClientPlayNetworking.send((class_2960)Weightless.UPDATE_TRAIL_COLOR_C2S_PACKET, (class_2540)buf2);
                    component.trailRed = red;
                    component.trailGreen = green;
                    component.trailBlue = blue;
                }
            }
        });
    }

    public void tick() {
        if (this.remainingStunTicks > 0) {
            --this.remainingStunTicks;
        }
    }

    public void clientTick() {
        this.tick();
        class_243 pos = new class_243(this.provider.method_23317(), this.provider.method_23318() + 2.0, this.provider.method_23321());
        this.trail.addPoint(pos);
        this.trail.tick();
    }

    public boolean autopilot() {
        return this.autopilot && (float)this.provider.method_7344().method_7586() > 6.0f && WeightlessComponent.canFly(this.provider);
    }

    public boolean has() {
        return this.enabled;
    }

    public void attain() {
        this.enabled = true;
        this.sync();
    }

    public void reset() {
        this.enabled = false;
        this.toggled = true;
        this.autopilot = false;
        this.flying = false;
        this.remainingStunTicks = 0;
        this.sync();
    }

    public void readFromNbt(class_2487 tag) {
        this.enabled = tag.method_10577("Enabled");
        this.toggled = tag.method_10577("Toggled");
        this.autopilot = tag.method_10577("Autopilot");
        this.flying = tag.method_10577("Flying");
        this.remainingStunTicks = tag.method_10550("StunTicks");
        this.trailRed = tag.method_10550("TrailRed");
        this.trailGreen = tag.method_10550("TrailGreen");
        this.trailBlue = tag.method_10550("TrailBlue");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("Enabled", this.enabled);
        tag.method_10556("Toggled", this.toggled);
        tag.method_10556("Autopilot", this.autopilot);
        tag.method_10556("Flying", this.flying);
        tag.method_10569("StunTicks", this.remainingStunTicks);
        tag.method_10569("TrailRed", this.trailRed);
        tag.method_10569("TrailGreen", this.trailGreen);
        tag.method_10569("TrailBlue", this.trailBlue);
    }

    public boolean isStunned() {
        return this.remainingStunTicks > 0;
    }

    public void setStunned() {
        this.remainingStunTicks = ModConfig.stunDuration;
        this.sync();
    }

    public boolean flying() {
        return this.has() && this.toggled && this.flying && WeightlessComponent.canFly(this.provider);
    }

    public void setFlying(boolean flying) {
        if (flying != this.flying) {
            this.flying = flying;
            this.sync();
        }
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
        this.sync();
    }

    public void setAutopilot(boolean autopilot) {
        this.autopilot = autopilot;
        this.sync();
    }

    public Trail getTrail() {
        return this.trail;
    }

    public void setTrailColor(int red, int green, int blue) {
        this.trailRed = red;
        this.trailGreen = green;
        this.trailBlue = blue;
        this.sync();
    }

    public Color getTrailColor() {
        return new Color(this.trailRed, this.trailGreen, this.trailBlue);
    }

    public static boolean canFly(class_1657 player) {
        return player.method_36608() && !player.method_7337() && !player.method_5765() && !player.method_20232() && !player.method_6123() && !player.method_6128() && !player.method_6113() && !player.method_6101();
    }

    public static class_243 relativeMovement(class_243 velocity, float yaw, boolean sprinting) {
        class_243 movement = velocity.method_1024(yaw * (float)Math.PI / 180.0f);
        double x = movement.field_1352;
        double y = velocity.field_1351;
        double z = movement.field_1350;
        if (sprinting) {
            x *= (double)1.1f;
            z *= 1.25;
        }
        double bound = 1.2566370614359172;
        if (y < 0.0) {
            x *= 1.0 - y;
            z = class_3532.method_16436((double)y, (double)z, (double)(-bound));
        }
        x = class_3532.method_15350((double)x, (double)(-bound), (double)bound);
        y = class_3532.method_15350((double)y, (double)(-bound), (double)bound);
        z = class_3532.method_15350((double)z, (double)(-bound), (double)bound);
        return new class_243(x, y, z);
    }
}

