/*
 * Decompiled with CFR 0.152.
 */
package shiny.weightless.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5329;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import shiny.weightless.ModConfig;
import shiny.weightless.Weightless;
import shiny.weightless.common.component.WeightlessComponent;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private boolean wasSprintFlying = false;
    @Unique
    private int startFlyingTicks = 0;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void weightless$sprintingCallback(CallbackInfo ci) {
        class_1657 player;
        class_1309 entity = (class_1309)this;
        if (entity instanceof class_1657 && WeightlessComponent.has(player = (class_1657)entity)) {
            boolean bl;
            boolean bl2 = bl = (entity.method_5624() || WeightlessComponent.autopilot(player)) && WeightlessComponent.canFly(player);
            if (bl && WeightlessComponent.flying(player) && !this.wasSprintFlying) {
                LivingEntityMixin.sendSoundPackets(player);
                this.wasSprintFlying = true;
            } else if (!(!this.wasSprintFlying || bl && WeightlessComponent.flying(player))) {
                this.wasSprintFlying = false;
            }
        }
    }

    @WrapOperation(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;travel(Lnet/minecraft/util/math/Vec3d;)V")})
    private void weightless$crosshairBasedMovement(class_1309 entity, class_243 movementInput, Operation<Void> original) {
        class_1657 player;
        if (entity instanceof class_1657 && WeightlessComponent.has(player = (class_1657)entity)) {
            boolean bl = WeightlessComponent.autopilot(player);
            boolean bl2 = !WeightlessComponent.flying(player);
            bl2 &= entity.method_36455() < -10.0f && movementInput.field_1350 > 0.0 || entity.method_36455() > 10.0f && movementInput.field_1350 < 0.0 || bl;
            boolean bl3 = false;
            if (this.startFlyingTicks == 0) {
                if (bl2) {
                    ++this.startFlyingTicks;
                } else {
                    bl3 = LivingEntityMixin.checkCollision((class_1297)entity);
                }
            }
            WeightlessComponent.get(player).setFlying(!bl3);
            if (WeightlessComponent.flying(player)) {
                if (bl) {
                    movementInput = new class_243(0.0, 0.0, 1.0);
                }
                float speed = LivingEntityMixin.getFlightSpeed(entity, entity.method_5624() || bl);
                class_243 movement = LivingEntityMixin.weightlessMovement(movementInput, speed, entity.method_36455(), entity.method_36454());
                class_243 velocity = entity.method_18798().method_1019(movement).method_18805(0.85, 0.85, 0.85);
                if (entity.method_5787()) {
                    double x = velocity.field_1352;
                    double y = velocity.field_1351;
                    double z = velocity.field_1350;
                    if (entity.method_5715() || entity.method_6115()) {
                        y *= 0.5;
                    }
                    if (Math.abs(x) < 0.003) {
                        x = 0.0;
                    }
                    if (Math.abs(y) < 0.003) {
                        y = 0.0;
                    }
                    if (Math.abs(z) < 0.003) {
                        z = 0.0;
                    }
                    velocity = new class_243(x, y, z);
                    entity.method_18799(velocity);
                    entity.method_5784(class_1313.field_6308, entity.method_18798());
                    entity.field_6017 = 0.1f;
                }
                if (entity.method_5715()) {
                    entity.method_29242(false);
                } else {
                    entity.field_42108.method_48568(0.0f, 0.1f);
                }
                entity.method_52208(bl3, velocity);
            } else {
                original.call(new Object[]{entity, movementInput});
            }
            this.startFlyingTicks = this.startFlyingTicks < 5 && this.startFlyingTicks > 0 ? ++this.startFlyingTicks : 0;
        } else {
            original.call(new Object[]{entity, movementInput});
        }
    }

    @WrapOperation(method={"takeKnockback"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/Vec3d;multiply(D)Lnet/minecraft/util/math/Vec3d;")})
    private class_243 weightless$receiveIncreasedKnockback(class_243 vector, double value, Operation<class_243> original) {
        class_1657 player;
        class_1309 entity;
        if (ModConfig.increaseKnockback && (entity = (class_1309)this) instanceof class_1657 && WeightlessComponent.has(player = (class_1657)entity)) {
            value *= (double)ModConfig.knockbackMultiplier;
        }
        return (class_243)original.call(new Object[]{vector, value});
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void weightless$stunOnDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 entity;
        if (ModConfig.shouldStun && amount >= ModConfig.damageRequirement && (entity = (class_1309)this) instanceof class_1657 && (player = (class_1657)entity).method_5805() && WeightlessComponent.flying(player) && (source.method_48789(Weightless.CAN_STUN) || source.method_5529() != null)) {
            WeightlessComponent.get(player).setStunned();
        }
    }

    @Unique
    private static float getFlightSpeed(class_1309 entity, boolean sprinting) {
        class_1657 player;
        if (entity instanceof class_1657 && WeightlessComponent.get(player = (class_1657)entity).isStunned()) {
            return 0.0f;
        }
        float speed = ModConfig.movementSpeedAffectSpeed ? entity.method_6029() : 0.1f;
        speed *= sprinting ? 1.0f : 0.35f;
        speed *= ModConfig.speedMultiplier;
        if (ModConfig.armorAffectSpeed) {
            speed *= Math.max(0.1f, -0.025f * (float)entity.method_6096() + 1.0f);
        }
        if (ModConfig.increaseSpeedWhenHigh && entity.method_19538().field_1351 >= (double)ModConfig.altitude) {
            speed *= ModConfig.highSpeedMultiplier;
        }
        return speed;
    }

    @Unique
    private static class_243 weightlessMovement(class_243 movementInput, float speed, float pitch, float yaw) {
        double d = movementInput.method_1027();
        if (d < 1.0E-7) {
            return class_243.field_1353;
        }
        class_243 vec3d = (d > 1.0 ? movementInput.method_1029() : movementInput).method_1021((double)speed);
        float vertical = (float)Math.sqrt(1.0f - Math.abs(pitch) / 90.0f);
        float x = class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * vertical;
        float y = -class_3532.method_15374((float)(pitch * ((float)Math.PI / 180)));
        float z = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * vertical;
        return new class_243(vec3d.field_1352 * (double)z - vec3d.field_1350 * (double)x, (double)((vec3d.field_1350 > 0.0 ? y : -y) * speed) * (movementInput.field_1350 != 0.0 ? 1.1 : 0.0), vec3d.field_1350 * (double)z + vec3d.field_1352 * (double)x);
    }

    @Unique
    private static boolean checkCollision(class_1297 entity) {
        class_1937 world = entity.method_37908();
        class_238 box = entity.method_5829().method_1012(0.0, -0.01, 0.0);
        class_5329 spliterator = new class_5329((class_1941)world, entity, box, false, (mutable, voxelShape) -> voxelShape);
        while (spliterator.hasNext()) {
            class_265 shape = (class_265)spliterator.next();
            if (shape.method_1110()) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static void sendSoundPackets(class_1657 source) {
        if (!source.method_37908().method_8608()) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10804(source.method_5628());
            for (class_3222 recipient : PlayerLookup.tracking((class_1297)source)) {
                ServerPlayNetworking.send((class_3222)recipient, (class_2960)Weightless.FLYING_SOUND_S2C_PACKET, (class_2540)buf);
            }
            ServerPlayNetworking.send((class_3222)((class_3222)source), (class_2960)Weightless.FLYING_SOUND_S2C_PACKET, (class_2540)buf);
        }
    }
}

