/*
 * Decompiled with CFR 0.152.
 */
package shiny.weightless.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import shiny.weightless.ModConfig;
import shiny.weightless.WeightlessRenderProvider;
import shiny.weightless.common.component.WeightlessComponent;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements WeightlessRenderProvider {
    @Unique
    private float lastLimbAngle = 0.0f;

    @Shadow
    public abstract void method_7322(float var1);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"increaseTravelMotionStats"}, at={@At(value="HEAD")})
    private void weightless$applyExhaustionWhenFlying(double dx, double dy, double dz, CallbackInfo ci) {
        if (ModConfig.exhaust) {
            class_1657 player = (class_1657)this;
            if (!this.method_5765() && WeightlessComponent.flying(player)) {
                float exhaustion = ModConfig.hungerMultiplier;
                if (ModConfig.reduceHungerWhenHigh && player.method_19538().field_1351 >= (double)ModConfig.altitude) {
                    exhaustion *= ModConfig.highHungerReduction;
                }
                float speed = (float)(dx * dx + dy * dy + dz * dz);
                if (exhaustion > 0.0f && (double)speed > 1.0E-7) {
                    if (this.method_5624() || WeightlessComponent.autopilot(player)) {
                        this.method_7322(0.04f * exhaustion);
                    } else {
                        this.method_7322(0.001f * exhaustion);
                    }
                }
            }
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void weightless$preventFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        if (WeightlessComponent.has(player)) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapWithCondition(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;setSprinting(Z)V")})
    private boolean weightless$staySprinting(class_1657 player, boolean value) {
        return !WeightlessComponent.flying(player);
    }

    @WrapOperation(method={"getBlockBreakingSpeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isOnGround()Z")})
    private boolean weightless$sameBreakingSpeed(class_1657 player, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{player}) != false || WeightlessComponent.flying(player);
    }

    @Override
    public float getLastLimbAngle() {
        return this.lastLimbAngle;
    }

    @Override
    public void setLastLimbAngle(float lastLimbAngle) {
        this.lastLimbAngle = lastLimbAngle;
    }
}

