/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class BackendConfig {
    public static final String DIRECTORY_NAME_DEFAULT = "AutoServer";
    private static final String CONFIG_FILE = "config.yml";
    private final File configDirectory;
    private Map<String, Object> data;

    public BackendConfig(File configDirectory) {
        this.configDirectory = configDirectory;
        this.reload();
    }

    public void reload() {
        File configFile = new File(this.configDirectory, CONFIG_FILE);
        System.out.println("Config file: " + configFile.getPath());
        if (!configFile.exists()) {
            System.out.println("Config file does not exist");
            if (!this.configDirectory.mkdirs()) {
                System.err.println("Failed to create config directory.");
                return;
            }
            this.extractDefaultConfig(configFile);
        }
        try {
            FileInputStream inputStream = new FileInputStream(configFile);
            Yaml yaml = new Yaml();
            this.data = (Map)yaml.load(inputStream);
            System.out.println(this.data);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(String path) {
        Object value = this.followPath(path);
        return value instanceof String ? (String)value : null;
    }

    public Boolean getBoolean(String path) {
        return this.getBoolean(path, null);
    }

    public Boolean getBoolean(String path, Boolean def) {
        Object value = this.followPath(path);
        return value instanceof Boolean ? (Boolean)value : def;
    }

    public Integer getInt(String path) {
        Object value = this.followPath(path);
        return value instanceof Integer ? (Integer)value : null;
    }

    public String getConfigPath() {
        return this.configDirectory.getPath();
    }

    private Object followPath(String path) {
        String[] keys = path.split("\\.");
        Object value = this.data;
        for (String key : keys) {
            if (!(value instanceof Map)) {
                return null;
            }
            value = value.get(key);
        }
        return value;
    }

    private void extractDefaultConfig(File configFile) {
        System.out.println("Creating file");
        try (InputStream inputStream = BackendConfig.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
             FileOutputStream outputStream = new FileOutputStream(configFile);){
            int bytesRead;
            if (inputStream == null) {
                System.err.println("Resource not found: config.yml");
                return;
            }
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            System.out.println("File extracted: " + configFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("We had an error while opening the resource: " + e.getMessage());
        }
    }
}

