/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.artificial.autoserver.common.BackendConfig;
import me.artificial.autoserver.common.CommandRunner;
import me.artificial.autoserver.common.NetworkCommands;

public class BootListener {
    private static final String PROMPT = "> ";
    private static final int CLIENT_TIMEOUT = 5000;
    private static final int SERVER_RETRIES = 10;
    private static final int DELAY_BETWEEN_RETIRES = 5000;
    private final ExecutorService clientHandlers = Executors.newCachedThreadPool();
    private Integer port = null;
    private BackendConfig config = null;
    private ServerSocket serverSocket = null;
    private volatile boolean running = true;
    private Thread socketThread;
    private Thread cliThread;

    public static void main(String[] args) {
        BootListener bootListener = new BootListener();
        bootListener.start();
    }

    private void start() {
        if (!this.initialize()) {
            return;
        }
        if (!this.setupServerSocket()) {
            return;
        }
        this.sendBannerMessage();
        this.socketThread = new Thread(this::socketServerLoop);
        this.cliThread = new Thread(this::cliLoop);
        this.socketThread.start();
        this.cliThread.start();
        try {
            this.cliThread.join();
            this.socketThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Backend Listener exited.");
    }

    private boolean initialize() {
        String path;
        try {
            path = new File(BootListener.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (URISyntaxException e) {
            System.err.println("Unable to resolve the file path for the config directory.");
            return false;
        }
        this.config = new BackendConfig(new File(path, "AutoServer"));
        this.port = this.config.getInt("bootListener.port");
        if (this.port == null) {
            System.err.println("Missing required setting \"bootListener.port\". Please add and restart.");
            return false;
        }
        return true;
    }

    private boolean setupServerSocket() {
        int retries = 10;
        while (this.running && retries-- > 0) {
            try {
                assert (this.port != null);
                this.serverSocket = new ServerSocket(this.port);
                return true;
            }
            catch (IOException e) {
                System.out.println("Error starting server: " + e.getMessage());
                System.out.println("Retrying to start server in 5 seconds...");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e2) {
                    System.out.println("Retry delay interrupted: " + e2.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
        }
        System.err.println("Failed to setup server socket.");
        return false;
    }

    private void sendBannerMessage() {
        long pid = ProcessHandle.current().pid();
        System.out.println("================================================");
        System.out.println("Boot Listener started with PID: " + pid);
        System.out.println("Current date: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        System.out.println("Config path: " + this.config.getConfigPath());
        System.out.println("Boot Listener listening on port: " + this.port);
        System.out.println("Type \"help\" for list of cli commands.");
        System.out.println("================================================");
    }

    private void cliLoop() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(PROMPT);
        while (this.running) {
            try {
                if (reader.ready()) {
                    String command = reader.readLine();
                    this.processCliCommand(command.trim());
                    if (this.running) {
                        System.out.print(PROMPT);
                    }
                }
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    private void socketServerLoop() {
        while (this.running) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                clientSocket.setSoTimeout(5000);
                System.out.println("Connection received from: " + String.valueOf(clientSocket.getInetAddress()));
                this.clientHandlers.submit(() -> this.handleClient(clientSocket));
            }
            catch (SocketException e) {
                if (this.running) {
                    System.err.println("ServerSocket accept error: " + e.getMessage());
                    break;
                }
                System.out.println("Server shutting down gracefully.");
                break;
            }
            catch (IOException e) {
                System.err.println("Error accepting client connection: " + e.getMessage());
            }
        }
    }

    private void handleClient(Socket clientSocket) {
        boolean securityEnabled = this.config.getBoolean("security.enabled", true);
        String secret = this.config.getString("security.secret");
        if (securityEnabled && secret == null) {
            System.out.println("Security is enabled, but the required setting \"security.secret\" is missing. Please add the setting and restart.");
            try {
                clientSocket.close();
            }
            catch (IOException e) {
                System.err.println("Error closing client socket: " + e.getMessage());
            }
            System.out.println("Client socket closed successfully");
            return;
        }
        try (InputStream input = clientSocket.getInputStream();
             OutputStream output = clientSocket.getOutputStream();){
            System.out.println("Client Thread waiting for command");
            byte[] lengthBytes = new byte[4];
            if (input.read(lengthBytes) != 4) {
                throw new RuntimeException("Failed to read length bytes.");
            }
            ByteBuffer lengthBuffer = ByteBuffer.wrap(lengthBytes);
            int totalLength = lengthBuffer.getInt();
            System.out.println("length of total bytes received: " + totalLength);
            byte[] dataBytes = new byte[totalLength];
            if (input.read(dataBytes) != totalLength) {
                throw new RuntimeException("Failed to read the full message.");
            }
            NetworkCommands.DecodedMessage decodedMessage = NetworkCommands.decodeData(dataBytes, securityEnabled);
            System.out.println("Received command: " + String.valueOf(decodedMessage));
            if (decodedMessage.isMalformed()) {
                throw new RuntimeException("Received a malformed message.");
            }
            if (decodedMessage.verify(secret)) {
                System.out.println("Authenticated command: " + decodedMessage.getCommand());
                this.processRemoteCommand(decodedMessage.getCommand(), output, securityEnabled, secret);
            } else {
                System.out.println("Authentication failed! Rejecting command.");
            }
        }
        catch (IOException | RuntimeException e) {
            System.err.println("Error handling client: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                Thread.sleep(50L);
                clientSocket.close();
                System.out.println("Client socket closed successfully");
            }
            catch (IOException e) {
                System.err.println("Error closing client socket: " + e.getMessage());
            }
            catch (InterruptedException e) {
                System.out.println("InterruptedException: " + e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    private void processRemoteCommand(String command, OutputStream output, Boolean securityEnabled, String secret) {
        switch (command) {
            case "BOOT_SERVER": {
                this.respond(output, securityEnabled, secret, "ACKNOWLEDGED");
                if (this.startBackendServer()) {
                    this.respond(output, securityEnabled, secret, "COMPLETED");
                    this.stopAll();
                    break;
                }
                this.respond(output, securityEnabled, secret, "FAILED");
                break;
            }
            case "SHUTDOWN_BOOT_LISTENER": {
                this.respond(output, securityEnabled, secret, "SUCCESS");
                this.stopAll();
                break;
            }
            default: {
                this.respond(output, securityEnabled, secret, "ERROR");
            }
        }
    }

    private void respond(OutputStream output, Boolean securityEnabled, String secret, String command) {
        System.out.println("Sending > " + command);
        byte[] encoded = NetworkCommands.encodeData(command, securityEnabled, secret);
        try {
            output.write(encoded);
            output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void processCliCommand(String command) {
        switch (command) {
            case "help": {
                System.out.println("Commands:");
                System.out.println("  help   - this message");
                System.out.println("  start  - start the backend server");
                System.out.println("  stop   - stop the boot listener");
                System.out.println("  reload - reload the config.yml file (port is not hot reloadable)");
                break;
            }
            case "reload": {
                this.config.reload();
                break;
            }
            case "stop": {
                this.stopAll();
                break;
            }
            case "start": {
                System.out.println("Starting backend server...");
                if (this.startBackendServer()) {
                    System.out.println("Command ran successfully.");
                    this.stopAll();
                    break;
                }
                System.out.println("Failed to start backend server.");
                break;
            }
            default: {
                System.out.println("Unknown command.");
            }
        }
    }

    private void stopAll() {
        new Thread(() -> {
            this.running = false;
            System.out.println("Shutting down server listener...");
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                    System.out.println("Server socket closed.");
                }
            }
            catch (IOException e) {
                System.err.println("Error closing server socket: " + e.getMessage());
            }
            System.out.println("Stopping client threads");
            this.clientHandlers.shutdownNow();
            this.cliThread.interrupt();
            this.socketThread.interrupt();
        }).start();
    }

    private boolean startBackendServer() {
        String out;
        Boolean preserveQuotes;
        String command = this.config.getString("server.startCommand");
        if (command == null) {
            System.err.println("Error reading start command. Check config for required setting \"server.startCommand\".");
            return false;
        }
        String workingDirectory = this.config.getString("server.workingDirectory");
        CommandRunner.CommandResult commandResult = CommandRunner.runCommand(workingDirectory, command, preserveQuotes = this.config.getBoolean("server.preserveQuotes"));
        if (commandResult.failedToStart()) {
            System.err.println(commandResult.getErrorMessage());
            return false;
        }
        if (commandResult.isTerminated() && !(out = commandResult.getProcessOutput()).isBlank()) {
            System.out.println("Command exited fast might have an error here is the output: " + out);
        }
        return true;
    }
}

