/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class CommandRunner {
    public static CommandResult runCommand(String path, String command, Boolean preserveQuotes) {
        ProcessBuilder processBuilder = CommandRunner.getProcessBuilder(path, command, preserveQuotes);
        boolean started = false;
        Process process = null;
        Object errorMsg = null;
        String commandParsed = String.join((CharSequence)" ", processBuilder.command());
        try {
            process = processBuilder.start();
            started = true;
        }
        catch (NullPointerException e) {
            errorMsg = "Element of command is null";
        }
        catch (IndexOutOfBoundsException e) {
            errorMsg = "Command is empty";
        }
        catch (UnsupportedOperationException e) {
            errorMsg = "Operating system does not support process creation";
        }
        catch (SecurityException e) {
            errorMsg = "Security manager has blocked the creation of the process";
        }
        catch (IOException e) {
            errorMsg = "IO error while executing the command: " + e.getMessage();
        }
        return new CommandResult(started, (String)errorMsg, path, commandParsed, process);
    }

    private static ProcessBuilder getProcessBuilder(String path, String command, Boolean preserveQuotes) {
        String os = System.getProperty("os.name").toLowerCase();
        ArrayList<String> tokenCommand = new ArrayList<String>(List.of(command.split("\\s+(?=(?:[^'\"]*['\"][^'\"]*['\"])*[^'\"]*$)")));
        if (preserveQuotes == null && !os.contains("win") || preserveQuotes != null && !preserveQuotes.booleanValue()) {
            ListIterator<String> iterator = tokenCommand.listIterator();
            while (iterator.hasNext()) {
                String word = (String)iterator.next();
                iterator.set(word.replaceAll("^\"|\"$|^'|'$", ""));
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(tokenCommand);
        if (path != null) {
            processBuilder.directory(new File(path));
        }
        processBuilder.redirectErrorStream(true);
        return processBuilder;
    }

    public static class CommandResult {
        private final boolean started;
        private final String errorMessage;
        private final String path;
        private final String command;
        private final Process process;

        public CommandResult(boolean started, String errorMessage, String path, String command, Process process) {
            this.started = started;
            this.errorMessage = errorMessage;
            this.path = path;
            this.command = command;
            this.process = process;
        }

        public boolean failedToStart() {
            return !this.started;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isTerminated() {
            return !this.process.isAlive();
        }

        public String getProcessOutput() {
            assert (!this.process.isAlive()) : "Must check that CommandResult.isTerminated() before calling getProcessOutput.";
            try {
                return new String(this.process.getInputStream().readAllBytes());
            }
            catch (IOException iOException) {
                return "";
            }
        }

        public int getExitCode() {
            assert (!this.process.isAlive()) : "Must check that CommandResult.isTerminated() before calling getExitCode.";
            return this.process.exitValue();
        }

        public String toString() {
            return "CommandResult{started=" + this.started + ", errorMessage='" + this.errorMessage + "', processId=" + this.process.pid() + ", path=" + this.path + ", command=" + this.command + "}";
        }
    }
}

