/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.common;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import me.artificial.autoserver.common.HMAC;

public class NetworkCommands {
    public static final String BOOT = "BOOT_SERVER";
    public static final String SHUTDOWN_BOOT_LISTENER = "SHUTDOWN_BOOT_LISTENER";
    public static final String ACKNOWLEDGED = "ACKNOWLEDGED";
    public static final String COMPLETED = "COMPLETED";
    public static final String FAILED = "FAILED";
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    public static byte[] encodeData(String command, Boolean securityEnabled, String secret) {
        if (securityEnabled.booleanValue()) {
            String signature;
            assert (secret != null);
            try {
                signature = HMAC.signMessage(command, secret);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int totalLength = 4 + command.length() + 4 + signature.length();
            ByteBuffer buffer = ByteBuffer.allocate(4 + totalLength);
            buffer.putInt(totalLength);
            buffer.putInt(command.length());
            buffer.put(command.getBytes());
            buffer.putInt(signature.length());
            buffer.put(signature.getBytes());
            return buffer.array();
        }
        int totalLength = 4 + command.length();
        ByteBuffer buffer = ByteBuffer.allocate(4 + totalLength);
        buffer.putInt(totalLength);
        buffer.putInt(command.length());
        buffer.put(command.getBytes());
        return buffer.array();
    }

    public static DecodedMessage decodeData(byte[] data, boolean securityEnabled) {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(data);
            int commandLength = buffer.getInt();
            byte[] commandBytes = new byte[commandLength];
            buffer.get(commandBytes);
            String command = new String(commandBytes);
            String signature = null;
            if (securityEnabled) {
                int signatureLength = buffer.getInt();
                byte[] signatureBytes = new byte[signatureLength];
                buffer.get(signatureBytes);
                signature = new String(signatureBytes);
            }
            return new DecodedMessage(buffer.remaining() != 0, command, signature);
        }
        catch (BufferUnderflowException e) {
            return new DecodedMessage(true, null, null);
        }
    }

    public static class DecodedMessage {
        private final boolean malformed;
        private final String command;
        private final String signature;

        public DecodedMessage(boolean malformed, String command, String signature) {
            this.malformed = malformed;
            this.command = command;
            this.signature = signature;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean isMalformed() {
            return this.malformed;
        }

        public boolean verify(String secret) {
            if (!this.malformed && this.signature == null) {
                return true;
            }
            boolean isValid = false;
            try {
                isValid = HMAC.verifyMessage(this.command, this.signature, secret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return isValid;
        }

        public String toString() {
            return "DecodedMessage{malformed=" + this.malformed + ", command=" + this.command + ", signature=" + this.signature + "}";
        }
    }
}

