/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import me.artificial.autoserver.velocity.AutoServerLogger;
import me.artificial.autoserver.velocity.Configuration;
import me.artificial.autoserver.velocity.Messenger;
import me.artificial.autoserver.velocity.RateLimiter;
import me.artificial.autoserver.velocity.ServerManager;
import me.artificial.autoserver.velocity.UpdateChecker;
import me.artificial.autoserver.velocity.commands.AutoServerCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.slf4j.Logger;

@Plugin(id="autoserver")
public class AutoServer {
    private final ProxyServer proxy;
    private final AutoServerLogger logger;
    private final PluginContainer pluginContainer;
    private final Configuration config;
    private final Set<UUID> internalTransfers = ConcurrentHashMap.newKeySet();
    private ServerManager serverManager;
    private RateLimiter rateLimiter;

    @Inject
    public AutoServer(ProxyServer proxy, Logger logger, @DataDirectory Path dataDirectory, PluginContainer pluginContainer) {
        this.proxy = proxy;
        this.config = new Configuration(dataDirectory);
        this.logger = new AutoServerLogger(this, logger);
        this.pluginContainer = pluginContainer;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.logger.info("Loading configuration...", new Object[0]);
        try {
            this.config.reloadConfig();
        }
        catch (Exception e) {
            this.logger.error("Failed to load config! Stopping plugin initialization.", new Object[0]);
            this.logger.error("", new Object[0]);
            this.logger.error(e.getMessage(), new Object[0]);
            this.logger.error("", new Object[0]);
            throw new RuntimeException("Failed to load config! Stopping plugin initialization.");
        }
        this.logger.info("Configuration Loaded", new Object[0]);
        this.serverManager = new ServerManager(this);
        CommandManager commandManager = this.proxy.getCommandManager();
        CommandMeta commandMeta = commandManager.metaBuilder("autoserver").aliases(new String[]{"as"}).plugin((Object)this).build();
        commandManager.register(commandMeta, (Command)new AutoServerCommand(this));
        if (this.config.checkForUpdate()) {
            this.notifyUpdates();
        }
        this.proxy.getScheduler().buildTask((Object)this, () -> {
            this.logger.trace("Maintenance task running.", new Object[0]);
            this.serverManager.validateServers(this.proxy.getAllServers());
        }).repeat(this.config.getMaintenanceInterval(), TimeUnit.MINUTES).schedule();
        this.rateLimiter = new RateLimiter(this.config.StartRateLimit());
        this.logger.info("Successfully enabled AutoServer", new Object[0]);
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.logger.info("Successfully disabled AutoServer", new Object[0]);
    }

    @Subscribe
    public void onServerPreConnect(ServerPreConnectEvent event) {
        Optional playerCurrentServer;
        if (this.internalTransfers.remove(event.getPlayer().getUniqueId())) {
            return;
        }
        long startTime = System.nanoTime();
        RegisteredServer originalServer = event.getOriginalServer();
        RegisteredServer previousServer = event.getPreviousServer();
        String originalServerName = originalServer.getServerInfo().getName();
        this.logger.debug("Player {} attempting to join {}", event.getPlayer().getUsername(), originalServerName);
        if (!this.rateLimiter.canRequest(event.getPlayer()) && (playerCurrentServer = event.getPlayer().getCurrentServer()).isPresent()) {
            Messenger.send(event.getPlayer(), this.config.getMessage("startRateLimitExceeded").orElse(""), this.rateLimiter.getRemainingCooldown(event.getPlayer()));
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
            this.logger.debug("Player {} exceeded rate limit, join request denied.", event.getPlayer().getUsername());
            return;
        }
        this.serverManager.cancelShutdownServer(originalServer);
        CompletableFuture<Boolean> isResponsive = this.serverManager.isServerResponsive(originalServer);
        try {
            if (isResponsive.get().booleanValue()) {
                this.logger.info("Server {}{}{} is online allowing connection", "\u001b[0;32m", originalServerName, "\u001b[0m");
                event.setResult(ServerPreConnectEvent.ServerResult.allowed((RegisteredServer)originalServer));
            } else {
                this.logger.info("Server {}{}{} is not online attempting to start server", "\u001b[0;31m", originalServerName, "\u001b[0m");
                event.setResult(ServerPreConnectEvent.ServerResult.denied());
                if (previousServer != null) {
                    Messenger.send(event.getPlayer(), this.config.getMessage("starting").orElse(""), originalServerName);
                }
                this.serverManager.queuePlayerForServerJoin(event.getPlayer(), originalServerName);
                this.serverManager.startServer(originalServer).exceptionally(ex -> {
                    Optional playerCurrentServer = event.getPlayer().getCurrentServer();
                    if (playerCurrentServer.isEmpty()) {
                        event.getPlayer().disconnect(Component.text((String)("Failed to start server " + originalServerName)).color((TextColor)NamedTextColor.RED));
                    } else {
                        Messenger.send(event.getPlayer(), this.config.getMessage("failed").orElse(""), originalServerName);
                    }
                    return null;
                });
            }
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error("Error occurred while determining the status of server {}", originalServerName);
            this.logger.error("Exception: {}", e.getMessage(), e);
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        this.logger.debug("onServerPreConnect completed in: {}", duration);
    }

    @Subscribe
    public void onServerPostConnect(ServerPostConnectEvent event) {
        this.logger.trace("{}ServerPostConnectEvent: {} {}", "\u001b[0;36m", event, "\u001b[0m");
        RegisteredServer previousServer = event.getPreviousServer();
        if (previousServer != null && previousServer.getPlayersConnected().isEmpty()) {
            this.serverManager.scheduleShutdownServer(previousServer);
        }
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        this.logger.trace("{}DisconnectEvent: {} {}", "\u001b[0;36m", event, "\u001b[0m");
        Player player = event.getPlayer();
        Optional serverConnection = player.getCurrentServer();
        if (serverConnection.isEmpty()) {
            return;
        }
        RegisteredServer server = ((ServerConnection)serverConnection.get()).getServer();
        int others = 0;
        for (Player p : server.getPlayersConnected()) {
            if (p.getUniqueId() == player.getUniqueId()) continue;
            ++others;
        }
        if (others <= 0) {
            this.serverManager.scheduleShutdownServer(server);
        }
    }

    @Subscribe
    public void onPlayerKicked(KickedFromServerEvent event) {
        this.logger.trace("{}KickedFromServerEvent: {} {}", "\u001b[0;36m", event, "\u001b[0m");
        Player player = event.getPlayer();
        RegisteredServer server = event.getServer();
        String kickedFrom = server.getServerInfo().getName();
        this.logger.debug("{} was kicked from {} for {}", player.getUsername(), kickedFrom, event.getServerKickReason().orElse(null));
        if (server.getPlayersConnected().isEmpty()) {
            this.serverManager.scheduleShutdownServer(server);
        }
    }

    public AutoServerLogger getLogger() {
        return this.logger;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ServerManager getServerManager() {
        return this.serverManager;
    }

    public Optional<String> getVersion() {
        return this.pluginContainer.getDescription().getVersion();
    }

    public String getSecret() {
        this.logger.trace("Getting secret from file.", new Object[0]);
        try {
            return new String(Files.readAllBytes(Paths.get("forwarding.secret", new String[0]))).trim();
        }
        catch (IOException e) {
            this.logger.error("Failed to get secret: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public void internalTransfer(Player player) {
        this.internalTransfers.add(player.getUniqueId());
    }

    private void notifyUpdates() {
        block5: {
            Optional<String> versionOptional = this.getVersion();
            if (versionOptional.isPresent()) {
                try {
                    String currentVersion = versionOptional.get();
                    UpdateChecker updateChecker = new UpdateChecker(this.logger, currentVersion);
                    if (updateChecker.isUpdateAvailable()) {
                        this.logger.info("======================================== ", new Object[0]);
                        this.logger.info(" A new update is available!", new Object[0]);
                        this.logger.info(" Current Version: {}", currentVersion);
                        this.logger.info(" Latest Version: {}", updateChecker.latest());
                        this.logger.info(" Download the latest version for new features and fixes.", new Object[0]);
                        this.logger.info("========================================", new Object[0]);
                        break block5;
                    }
                    this.logger.info("You are using the latest version ({}). No updates available.", currentVersion);
                }
                catch (Exception ignored) {
                    this.logger.warn("Could not check for updates, check your connection.", new Object[0]);
                }
            } else {
                this.logger.warn("Unable to determine the current version. Update check skipped.", new Object[0]);
            }
        }
    }
}

