/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity;

import me.artificial.autoserver.velocity.AutoServer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class AutoServerLogger {
    private final Logger logger;
    private final AutoServer plugin;

    public AutoServerLogger(AutoServer plugin, Logger logger) {
        this.plugin = plugin;
        this.logger = logger;
    }

    public void trace(String msg, Object ... args) {
        this.log(Level.TRACE, msg, args);
    }

    public void debug(String msg, Object ... args) {
        this.log(Level.DEBUG, msg, args);
    }

    public void info(String msg, Object ... args) {
        this.log(Level.INFO, msg, args);
    }

    public void warn(String msg, Object ... args) {
        this.log(Level.WARN, msg, args);
    }

    public void error(String msg, Object ... args) {
        this.log(Level.ERROR, msg, args);
    }

    private void log(Level level, String message, Object ... args) {
        if (this.shouldLog(level)) {
            switch (level) {
                case TRACE: {
                    this.logger.info(message, args);
                    break;
                }
                case DEBUG: {
                    this.logger.info(message, args);
                    break;
                }
                case INFO: {
                    this.logger.info(message, args);
                    break;
                }
                case WARN: {
                    this.logger.warn(message, args);
                    break;
                }
                case ERROR: {
                    this.logger.error(message, args);
                }
            }
        }
    }

    private boolean shouldLog(Level level) {
        String currentLevel = this.plugin.getConfig().getLogLevel();
        Level logLevel = Level.valueOf((String)currentLevel);
        return level.toInt() >= logLevel.toInt();
    }
}

