/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity;

import com.moandjiezana.toml.Toml;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;

public class Configuration {
    private static final long DEFAULT_START_UP_DELAY = 60L;
    private static final long DEFAULT_SHUTDOWN_DELAY = 5L;
    private static final int DEFAULT_REMOTE_PORT = 8080;
    private static final long DEFAULT_COMMUNICATION_VERSION = 2L;
    private static final long DEFAULT_AUTO_SHUTDOWN_DELAY = -1L;
    private final Path dataDirectory;
    private Toml config;

    public Configuration(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.config = new Toml();
    }

    public void reloadConfig() throws RuntimeException {
        this.config = this.loadConfig(this.dataDirectory);
    }

    public Optional<String> getMessage(String messageType) {
        String prefix = this.config.getString("messages.prefix", "");
        String message = this.config.getString("messages." + messageType);
        if (message == null) {
            return Optional.empty();
        }
        return Optional.of(prefix + message);
    }

    public Optional<String> getPath(RegisteredServer server) {
        String path = this.config.getString("servers." + server.getServerInfo().getName() + ".workingDirectory");
        return Optional.ofNullable(path);
    }

    public Optional<Boolean> getPreserveQuotes(RegisteredServer server) {
        Boolean quotes = this.config.getBoolean("servers." + server.getServerInfo().getName() + ".preserveQuotes");
        return Optional.ofNullable(quotes);
    }

    public Optional<String> getStartCommand(RegisteredServer server) {
        String command = this.config.getString("servers." + server.getServerInfo().getName() + ".start");
        return Optional.ofNullable(command);
    }

    public Optional<String> getStopCommand(RegisteredServer server) {
        String command = this.config.getString("servers." + server.getServerInfo().getName() + ".stop");
        return Optional.ofNullable(command);
    }

    public Optional<Boolean> isRemoteServer(RegisteredServer server) {
        Boolean remote = this.config.getBoolean("servers." + server.getServerInfo().getName() + ".remote");
        return Optional.ofNullable(remote);
    }

    public Optional<Integer> getPort(RegisteredServer server) {
        Long longPort = this.config.getLong("servers." + server.getServerInfo().getName() + ".port");
        if (longPort == null) {
            return Optional.of(8080);
        }
        if (longPort < 0L || longPort > 65535L) {
            return Optional.empty();
        }
        return Optional.of(longPort.intValue());
    }

    public boolean getSecurity(RegisteredServer server) {
        return this.config.getBoolean("servers." + server.getServerInfo().getName() + ".security", Boolean.valueOf(true));
    }

    public long getStartUpDelay(RegisteredServer server) {
        return this.config.getLong("servers." + server.getServerInfo().getName() + ".startupDelay", Long.valueOf(60L));
    }

    public long getShutdownDelay(RegisteredServer server) {
        return this.config.getLong("servers." + server.getServerInfo().getName() + ".shutdownDelay", Long.valueOf(5L));
    }

    public long getAutoShutdownDelay(RegisteredServer server) {
        return this.config.getLong("servers." + server.getServerInfo().getName() + ".autoShutdownDelay", Long.valueOf(-1L));
    }

    public boolean checkForUpdate() {
        return this.config.getBoolean("checkForUpdates", Boolean.valueOf(true));
    }

    public String getLogLevel() {
        return this.config.getString("logging.level", "INFO").toUpperCase();
    }

    public int getCommunicationVersion(RegisteredServer server) {
        return this.config.getLong("servers." + server.getServerInfo().getName() + ".communicationVersion", Long.valueOf(2L)).intValue();
    }

    public long getMaintenanceInterval() {
        return this.config.getLong("maintenanceInterval", Long.valueOf(5L));
    }

    public long StartRateLimit() {
        return this.config.getLong("startRateLimit", Long.valueOf(2L));
    }

    private Toml loadConfig(Path path) throws RuntimeException {
        File configFile = new File(path.toFile(), "config.toml");
        try {
            if (!configFile.exists()) {
                if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create parent directories for config file.");
                }
                InputStream input = this.getClass().getResourceAsStream("/" + configFile.getName());
                if (input != null) {
                    Files.copy(input, configFile.toPath(), new CopyOption[0]);
                } else if (!configFile.createNewFile()) {
                    throw new IOException("Failed to create a new config file.");
                }
            }
            return new Toml().read(configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

