/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity;

import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class RateLimiter {
    private final long maxRequestsPerMinute;
    private final long windowMillis = TimeUnit.MINUTES.toMillis(1L);
    private final Map<UUID, ArrayList<Long>> requests = new HashMap<UUID, ArrayList<Long>>();

    RateLimiter(long maxRequestsPerMinute) {
        this.maxRequestsPerMinute = maxRequestsPerMinute;
    }

    public boolean canRequest(Player player) {
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        this.requests.putIfAbsent(playerId, new ArrayList());
        ArrayList<Long> timestamps = this.requests.get(playerId);
        timestamps.removeIf(stamp -> currentTime - stamp > this.windowMillis);
        if ((long)timestamps.size() < this.maxRequestsPerMinute) {
            timestamps.add(currentTime);
            return true;
        }
        return false;
    }

    public long getRemainingCooldown(Player player) {
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        ArrayList<Long> timestamps = this.requests.get(playerId);
        if (timestamps == null || timestamps.isEmpty()) {
            return 0L;
        }
        timestamps.removeIf(stamp -> currentTime - stamp > this.windowMillis);
        if ((long)timestamps.size() < this.maxRequestsPerMinute) {
            return 0L;
        }
        long oldest = timestamps.get(0);
        long timeUntilReset = this.windowMillis - (currentTime - oldest);
        return TimeUnit.MILLISECONDS.toSeconds(Math.max(timeUntilReset, 0L));
    }
}

