/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity;

import java.time.Instant;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ServerStatus {
    private Status status;
    private Instant timestamp;

    public ServerStatus() {
        this.setStatus(Status.UNKNOWN);
    }

    public String getDisplayName() {
        return switch (this.status) {
            default -> throw new IncompatibleClassChangeError();
            case Status.RUNNING -> "Online";
            case Status.STOPPED -> "Offline";
            case Status.STARTING -> "Starting";
            case Status.STOPPING -> "Stopping";
            case Status.UNKNOWN -> "Unknown";
        };
    }

    public TextColor getColor() {
        return switch (this.status) {
            default -> throw new IncompatibleClassChangeError();
            case Status.RUNNING -> NamedTextColor.GREEN;
            case Status.STOPPED -> NamedTextColor.GRAY;
            case Status.STARTING -> NamedTextColor.YELLOW;
            case Status.STOPPING -> NamedTextColor.BLUE;
            case Status.UNKNOWN -> NamedTextColor.RED;
        };
    }

    public void setStatus(Status status) {
        this.timestamp = Instant.now();
        this.status = status;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean isStopping() {
        return this.status.equals((Object)Status.STOPPING);
    }

    public boolean isStarting() {
        return this.status.equals((Object)Status.STARTING);
    }

    public boolean is(Status status) {
        return this.status.equals((Object)status);
    }

    public String toString() {
        return this.getDisplayName() + " (Set at: " + String.valueOf(this.timestamp) + ")";
    }

    public static enum Status {
        RUNNING,
        STOPPED,
        STARTING,
        STOPPING,
        UNKNOWN;

    }
}

