/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import me.artificial.autoserver.velocity.AutoServerLogger;

public class UpdateChecker {
    private final AutoServerLogger logger;
    private final String currentVersion;
    private String latest;

    UpdateChecker(AutoServerLogger logger, String version) {
        this.logger = logger;
        this.currentVersion = version;
    }

    public boolean isUpdateAvailable() throws IndexOutOfBoundsException, IOException, InterruptedException {
        JsonArray versions = this.getVersions();
        if (versions == null) {
            return false;
        }
        JsonObject latest = versions.get(0).getAsJsonObject();
        this.latest = latest.get("version_number").getAsString();
        return !this.latest.equals(this.currentVersion);
    }

    public String latest() {
        return this.latest == null ? this.currentVersion : this.latest;
    }

    private JsonArray getVersions() throws IOException, InterruptedException, UncheckedIOException {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create("https://api.modrinth.com/v2/project/autoserver/version?loaders=[%22velocity%22]")).header("User-Agent", "autoserver").GET().build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            return JsonParser.parseString((String)response.body()).getAsJsonArray();
        }
        this.logger.debug("Request failed with status code: {}", response.statusCode());
        return null;
    }
}

