/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.artificial.autoserver.velocity.AutoServer;
import me.artificial.autoserver.velocity.commands.HelpCommand;
import me.artificial.autoserver.velocity.commands.InfoCommand;
import me.artificial.autoserver.velocity.commands.ReloadCommand;
import me.artificial.autoserver.velocity.commands.StartCommand;
import me.artificial.autoserver.velocity.commands.StatusCommand;
import me.artificial.autoserver.velocity.commands.StopCommand;
import me.artificial.autoserver.velocity.commands.SubCommand;
import me.artificial.autoserver.velocity.commands.VersionCommand;
import net.kyori.adventure.text.Component;

public class AutoServerCommand
implements SimpleCommand {
    private final HashMap<String, SubCommand> subCommands = new HashMap();

    public AutoServerCommand(AutoServer plugin) {
        this.subCommands.put("reload", new ReloadCommand(plugin));
        this.subCommands.put("help", new HelpCommand(this.subCommands));
        this.subCommands.put("status", new StatusCommand(plugin));
        this.subCommands.put("info", new InfoCommand(plugin));
        this.subCommands.put("start", new StartCommand(plugin));
        this.subCommands.put("stop", new StopCommand(plugin));
        this.subCommands.put("version", new VersionCommand(plugin));
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            this.subCommands.get("help").execute(source, args);
            return;
        }
        SubCommand command = this.subCommands.get(args[0].toLowerCase());
        if (command != null) {
            command.execute(source, args);
        } else {
            source.sendMessage((Component)Component.text((String)("Unknown subcommand: " + args[0])));
        }
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String command;
        String[] args = (String[])invocation.arguments();
        ArrayList<String> commands = new ArrayList<String>(this.subCommands.keySet());
        if (args.length == 0) {
            return commands;
        }
        if (args.length == 1) {
            String part = args[0].toLowerCase();
            return this.subCommands.keySet().stream().filter(cmd -> cmd.startsWith(part)).toList();
        }
        if (args.length == 2 && this.subCommands.containsKey(command = args[0].toLowerCase())) {
            return this.subCommands.get(command).suggest(invocation);
        }
        return List.of();
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (!invocation.source().hasPermission("autoserver.base")) {
            return false;
        }
        if (args.length == 0) {
            return true;
        }
        String command = args[0];
        if (this.subCommands.containsKey(command)) {
            return this.subCommands.get(command).hasPermission(invocation);
        }
        return true;
    }
}

