/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.List;
import java.util.Optional;
import me.artificial.autoserver.velocity.AutoServer;
import me.artificial.autoserver.velocity.ServerStatus;
import me.artificial.autoserver.velocity.commands.SubCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class InfoCommand
implements SubCommand {
    private final AutoServer plugin;

    public InfoCommand(AutoServer plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(CommandSource source, String[] args) {
        if (args.length != 2) {
            source.sendMessage((ComponentLike)Component.text().content("Usage /autoserver info <serverName>"));
            return;
        }
        Optional optionalServer = this.plugin.getProxy().getServer(args[1]);
        if (optionalServer.isEmpty()) {
            source.sendMessage((ComponentLike)Component.text().content("Unknown server name. Double check spelling."));
            return;
        }
        RegisteredServer server = (RegisteredServer)optionalServer.get();
        ServerStatus serverStatus = this.plugin.getServerManager().getServerStatus(server);
        String message = this.buildMessage(server, serverStatus);
        source.sendMessage(MiniMessage.miniMessage().deserialize((Object)message));
    }

    private String buildMessage(RegisteredServer server, ServerStatus serverStatus) {
        String statusColor = serverStatus.getColor().toString();
        String status = serverStatus.getDisplayName();
        String message = "<bold>Server Info: <aqua>%s</aqua></bold>\n<gray>--------------------------------------</gray>\nStatus: <%s>%s</%s>\nIP: <gold>%s</gold>\nPort: <gold>%d</gold>\n<gray>--------------------------------------</gray>\n";
        message = String.format(message, server.getServerInfo().getName(), statusColor, status, statusColor, server.getServerInfo().getAddress().getAddress(), server.getServerInfo().getAddress().getPort());
        return message;
    }

    @Override
    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("autoserver.command.info");
    }

    @Override
    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 2) {
            String part = args[1].toLowerCase();
            return this.plugin.getProxy().getAllServers().stream().map(s -> s.getServerInfo().getName()).filter(name -> name.toLowerCase().startsWith(part)).toList();
        }
        return List.of();
    }

    @Override
    public String help() {
        return "Show more details about the server";
    }
}

