/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.List;
import me.artificial.autoserver.velocity.AutoServer;
import me.artificial.autoserver.velocity.commands.SubCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ReloadCommand
implements SubCommand {
    private final AutoServer plugin;

    public ReloadCommand(AutoServer plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(CommandSource source, String[] args) {
        if (args.length != 1) {
            source.sendMessage((ComponentLike)Component.text().content("Usage /autoserver reload"));
            return;
        }
        this.plugin.getLogger().info("Reloading configuration...", new Object[0]);
        try {
            this.plugin.getConfig().reloadConfig();
            this.plugin.getLogger().info("Configuration reloaded.", new Object[0]);
            source.sendMessage((Component)Component.text((String)"Configuration reloaded."));
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Failed to load config! Fix errors and try again: {}", e.getMessage());
            source.sendMessage(Component.text((String)"Configuration failed to reloaded.").color((TextColor)NamedTextColor.RED));
        }
    }

    @Override
    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("autoserver.command.reload");
    }

    @Override
    public List<String> suggest(SimpleCommand.Invocation invocation) {
        return List.of();
    }

    @Override
    public String help() {
        return "Reloads the config file";
    }
}

