/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.List;
import java.util.Optional;
import me.artificial.autoserver.velocity.AutoServer;
import me.artificial.autoserver.velocity.ServerStatus;
import me.artificial.autoserver.velocity.commands.SubCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;

public class StatusCommand
implements SubCommand {
    private final AutoServer plugin;

    public StatusCommand(AutoServer plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(CommandSource source, String[] args) {
        if (args.length != 2 && args.length != 1) {
            source.sendMessage((ComponentLike)Component.text().content("Usage /autoserver status [serverName]"));
            return;
        }
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().content("Server Status").decorate(TextDecoration.BOLD);
        if (args.length == 2) {
            if (!this.handleSingleServer(builder, args[1])) {
                this.plugin.getLogger().warn("Error getting server, name is probably wrong", new Object[0]);
                source.sendMessage((ComponentLike)Component.text().content("Failed to check status, double check spelling."));
                return;
            }
        } else {
            this.handleAllServers(builder);
        }
        source.sendMessage((Component)builder.build());
    }

    private boolean handleSingleServer(TextComponent.Builder builder, String serverName) {
        Optional optionalServer = this.plugin.getProxy().getServer(serverName);
        if (optionalServer.isEmpty()) {
            return false;
        }
        ServerStatus status = this.plugin.getServerManager().getServerStatus((RegisteredServer)optionalServer.get());
        ((TextComponent.Builder)builder.appendNewline()).append(Component.text().content(serverName).color(status.getColor()));
        return true;
    }

    private void handleAllServers(TextComponent.Builder builder) {
        for (RegisteredServer server : this.plugin.getProxy().getAllServers()) {
            ServerStatus status = this.plugin.getServerManager().getServerStatus(server);
            ((TextComponent.Builder)builder.appendNewline()).append(Component.text().content(server.getServerInfo().getName()).color(status.getColor()));
        }
    }

    @Override
    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("autoserver.command.status");
    }

    @Override
    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 2) {
            String part = args[1].toLowerCase();
            return this.plugin.getProxy().getAllServers().stream().map(s -> s.getServerInfo().getName()).filter(name -> name.toLowerCase().startsWith(part)).toList();
        }
        return List.of();
    }

    @Override
    public String help() {
        return "Show status of all servers or a specific";
    }
}

