/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.List;
import java.util.Optional;
import me.artificial.autoserver.velocity.AutoServer;
import me.artificial.autoserver.velocity.commands.SubCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class VersionCommand
implements SubCommand {
    private final String version;

    public VersionCommand(AutoServer plugin) {
        Optional<String> versionOptional = plugin.getVersion();
        this.version = versionOptional.orElse("Unknown");
    }

    @Override
    public void execute(CommandSource source, String[] args) {
        if (args.length != 1) {
            source.sendMessage((ComponentLike)Component.text().content("Usage /autoserver version"));
            return;
        }
        source.sendMessage(MiniMessage.miniMessage().deserialize((Object)("<white>Version: </white><yellow>" + this.version + "</yellow>")));
    }

    @Override
    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("autoserver.command.version");
    }

    @Override
    public List<String> suggest(SimpleCommand.Invocation invocation) {
        return List.of();
    }

    @Override
    public String help() {
        return "Version of the plugin";
    }
}

