/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity.startable;

import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.artificial.autoserver.common.CommandRunner;
import me.artificial.autoserver.velocity.AutoServer;
import me.artificial.autoserver.velocity.startable.Startable;

public class LocalStartable
implements Startable {
    private final AutoServer plugin;
    private final RegisteredServer server;

    public LocalStartable(AutoServer plugin, RegisteredServer server) {
        this.plugin = plugin;
        this.server = server;
    }

    @Override
    public CompletableFuture<String> start() {
        return CompletableFuture.supplyAsync(() -> {
            Optional<String> command = this.plugin.getConfig().getStartCommand(this.server);
            if (command.isEmpty()) {
                this.plugin.getLogger().error("Start command not found for {}", this.server.getServerInfo().getName());
                throw new RuntimeException("Command not found");
            }
            Optional<String> path = this.plugin.getConfig().getPath(this.server);
            Optional<Boolean> preserveQuotes = this.plugin.getConfig().getPreserveQuotes(this.server);
            this.plugin.getLogger().info("Running start command for {} server. \"{}{}{}\"", this.server.getServerInfo().getName(), "\u001b[0;33m", command.get(), "\u001b[0m");
            return this.runCommand(path.orElse(null), command.get(), preserveQuotes.orElse(null));
        });
    }

    @Override
    public CompletableFuture<String> stop() {
        return CompletableFuture.supplyAsync(() -> {
            Optional<String> command = this.plugin.getConfig().getStopCommand(this.server);
            if (command.isEmpty()) {
                this.plugin.getLogger().error("Stop command not found for {}", this.server.getServerInfo().getName());
                throw new RuntimeException("Command not found");
            }
            Optional<String> path = this.plugin.getConfig().getPath(this.server);
            Optional<Boolean> preserveQuotes = this.plugin.getConfig().getPreserveQuotes(this.server);
            this.plugin.getLogger().info("Running stop command for {} server. \"{}{}{}\"", this.server.getServerInfo().getName(), "\u001b[0;33m", command.get(), "\u001b[0m");
            return this.runCommand(path.orElse(null), command.get(), preserveQuotes.orElse(null));
        });
    }

    private String runCommand(String path, String command, Boolean preserveQuotes) throws RuntimeException {
        CommandRunner.CommandResult commandResult = CommandRunner.runCommand(path, command, preserveQuotes);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (commandResult.failedToStart()) {
            throw new RuntimeException(commandResult.getErrorMessage());
        }
        this.plugin.getLogger().debug("Command Result: {}", commandResult);
        if (commandResult.isTerminated()) {
            String out = commandResult.getProcessOutput();
            if (!out.isBlank()) {
                this.plugin.getLogger().info("The command exited quickly, which may indicate an error. Here is the output: {}{}{}", "\u001b[0;33m", out, "\u001b[0m");
            }
            if (commandResult.getExitCode() != 0) {
                this.plugin.getLogger().error("Process exited with a non-zero exit code: {}", commandResult.getExitCode());
                throw new RuntimeException("Command failed to run.");
            }
        }
        return "Command ran successfully";
    }
}

