/*
 * Decompiled with CFR 0.152.
 */
package me.artificial.autoserver.velocity.startable;

import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.artificial.autoserver.common.NetworkCommands;
import me.artificial.autoserver.velocity.AutoServer;
import me.artificial.autoserver.velocity.startable.Startable;

public class RemoteStartable
implements Startable {
    private static final int TIMEOUT = 5000;
    private final AutoServer plugin;
    private final RegisteredServer server;

    public RemoteStartable(AutoServer plugin, RegisteredServer server) {
        this.plugin = plugin;
        this.server = server;
    }

    @Override
    public CompletableFuture<String> start() {
        return CompletableFuture.supplyAsync(() -> {
            this.plugin.getLogger().trace("RemoteStartable start enter", new Object[0]);
            InetAddress ip = this.server.getServerInfo().getAddress().getAddress();
            Optional<Integer> port = this.plugin.getConfig().getPort(this.server);
            if (port.isEmpty()) {
                this.plugin.getLogger().error("Invalid port value for server {}. Valid port range is 0 to 65535.", this.server.getServerInfo().getName());
                throw new RuntimeException("Invalid port value.");
            }
            this.plugin.getLogger().trace("Port is valid", new Object[0]);
            boolean securityEnabled = this.plugin.getConfig().getSecurity(this.server);
            String secret = this.plugin.getSecret();
            if (securityEnabled && secret == null) {
                this.plugin.getLogger().error("Security enabled for {} but no secret is present.", this.server.getServerInfo().getName());
                throw new RuntimeException("Security failed.");
            }
            try (Socket socket = new Socket(ip, (int)port.get());
                 InputStream input = socket.getInputStream();
                 OutputStream output = socket.getOutputStream();){
                socket.setSoTimeout(5000);
                this.plugin.getLogger().debug("Attempting to send BOOT command", new Object[0]);
                int communicationVersion = this.plugin.getConfig().getCommunicationVersion(this.server);
                this.plugin.getLogger().trace("communicationVersion is this {}", communicationVersion);
                if (communicationVersion == 1) {
                    this.plugin.getLogger().warn("WARNING: Legacy communication protocol (< v1.4.0) is currently in use.", new Object[0]);
                    this.plugin.getLogger().warn("This legacy mode is a temporary fallback and will be deprecated in a future release.", new Object[0]);
                    this.plugin.getLogger().warn("For uninterrupted remote compatibility and access to new features, please update your backend plugin/mod to version 1.4.0 or later.", new Object[0]);
                    String commandBoot = "BOOT_SERVER\n";
                    output.write(commandBoot.getBytes());
                    output.flush();
                    byte[] buffer = new byte[1024];
                    boolean noResponse = true;
                    block55: while (true) {
                        int read;
                        if ((read = input.read(buffer)) == -1) {
                            if (!noResponse) throw new RuntimeException("Unknown Error.");
                            this.plugin.getLogger().warn("No response received from the server.", new Object[0]);
                            throw new RuntimeException("No response received from the server.");
                        }
                        String response = new String(buffer, 0, read);
                        noResponse = false;
                        this.plugin.getLogger().debug("Server Response: {}", response.trim());
                        if (response.isBlank()) {
                            this.plugin.getLogger().debug("Received an empty or null response.", new Object[0]);
                            String string = "";
                            return string;
                        }
                        String[] parts = response.split(":", 2);
                        if (parts.length < 2) {
                            this.plugin.getLogger().debug("Malformed response received: {}", response);
                            String string = "";
                            return string;
                        }
                        String status = parts[0].trim();
                        String message = parts[1].trim();
                        this.plugin.getLogger().debug("Response Status: {}, Message: {}", status, message);
                        switch (status.toUpperCase()) {
                            case "ACKNOWLEDGED": {
                                this.plugin.getLogger().info("Backend server has acknowledged boot command.", new Object[0]);
                                continue block55;
                            }
                            case "COMPLETED": {
                                this.plugin.getLogger().info("Backend server booting.", new Object[0]);
                                String string = "Backend server booting";
                                return string;
                            }
                            case "FAILED": {
                                this.plugin.getLogger().error("Backend server failed to start. Message: {}", message);
                                throw new RuntimeException("Backend server failed to start.");
                            }
                            case "ERROR": {
                                this.plugin.getLogger().warn("Error occurred on the backend server with message: {}", message);
                                continue block55;
                            }
                        }
                        this.plugin.getLogger().warn("Unexpected status received: {}. Message: {}", status, message);
                    }
                }
                byte[] encoded = NetworkCommands.encodeData("BOOT_SERVER", securityEnabled, secret);
                output.write(encoded);
                output.flush();
                block56: while (true) {
                    byte[] lengthBytes;
                    if (input.read(lengthBytes = new byte[4]) != 4) {
                        throw new RuntimeException("Unknown Error.");
                    }
                    ByteBuffer lengthBuffer = ByteBuffer.wrap(lengthBytes);
                    int totalLength = lengthBuffer.getInt();
                    byte[] dataBytes = new byte[totalLength];
                    if (input.read(dataBytes) != totalLength) {
                        throw new RuntimeException("Unknown Error.");
                    }
                    NetworkCommands.DecodedMessage decodedMessage = NetworkCommands.decodeData(dataBytes, securityEnabled);
                    this.plugin.getLogger().debug("Received command: {}", decodedMessage);
                    switch (decodedMessage.getCommand()) {
                        case "ACKNOWLEDGED": {
                            this.plugin.getLogger().info("Backend server has acknowledged boot command.", new Object[0]);
                            continue block56;
                        }
                        case "COMPLETED": {
                            this.plugin.getLogger().info("Backend server booting.", new Object[0]);
                            String string = "Backend server booting";
                            return string;
                        }
                        case "FAILED": {
                            this.plugin.getLogger().error("Backend server failed to start.", new Object[0]);
                            throw new RuntimeException("Backend server failed to start.");
                        }
                        case "ERROR": {
                            this.plugin.getLogger().warn("Error occurred on the backend server.", new Object[0]);
                            continue block56;
                        }
                    }
                    this.plugin.getLogger().warn("Unexpected command: {}", decodedMessage.getCommand());
                }
            }
            catch (SocketTimeoutException e) {
                this.plugin.getLogger().error("Timeout waiting for server response.", new Object[0]);
                throw new RuntimeException("Unknown Error.");
            }
            catch (SocketException e) {
                this.plugin.getLogger().error("Socket closed, exiting read loop.", new Object[0]);
                throw new RuntimeException("Unknown Error.");
            }
            catch (IOException e) {
                throw new RuntimeException("Error while communicating with the server.");
            }
        });
    }

    @Override
    public CompletableFuture<String> stop() {
        return null;
    }
}

