/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_2960;

@Config(name="flatterentities")
public class FlatConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public Client client = new Client();

    private static boolean isValidResourceLocation(String configValue) {
        return configValue.isEmpty() || class_2960.method_12829((String)configValue) != null;
    }

    public static boolean isValidOption(String configValue) {
        String[] splitValue;
        String value = configValue;
        if (value.isEmpty()) {
            return true;
        }
        if (value.contains(",") && (splitValue = value.split(",")).length == 2) {
            return class_2960.method_12829((String)splitValue[0]) != null && class_2960.method_12829((String)splitValue[1]) != null;
        }
        return false;
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        List<String> dimensionBlacklist;
        List<String> entityDimensionWhitelist;
        List<String> entityBlacklist = this.client.entityBlacklist;
        if (!entityBlacklist.isEmpty()) {
            ListIterator<String> iter = entityBlacklist.listIterator();
            while (iter.hasNext()) {
                String value = iter.next();
                if (FlatConfig.isValidResourceLocation(value)) continue;
                iter.set("");
            }
            this.client.entityBlacklist = entityBlacklist;
        }
        if (!(entityDimensionWhitelist = this.client.entityDimensionWhitelist).isEmpty()) {
            ListIterator<String> iter = entityDimensionWhitelist.listIterator();
            while (iter.hasNext()) {
                String value = iter.next();
                if (FlatConfig.isValidOption(value)) continue;
                iter.set("");
            }
            this.client.entityDimensionWhitelist = entityDimensionWhitelist;
        }
        if (!(dimensionBlacklist = this.client.dimensionBlacklist).isEmpty()) {
            ListIterator<String> iter = dimensionBlacklist.listIterator();
            while (iter.hasNext()) {
                String value = iter.next();
                if (FlatConfig.isValidResourceLocation(value)) continue;
                iter.set("");
            }
            this.client.dimensionBlacklist = dimensionBlacklist;
        }
    }

    public static class Client {
        @Comment(value="A list of entities that won't show flat ever [Syntax: \"modid:entity\" ]\n[Example: \"minecraft:cow\"]")
        public List<String> entityBlacklist = new ArrayList<String>();
        @Comment(value="A list of entities that will show flat even when a dimension is blacklisted [Syntax: \"modid:entity,modid:dimension\" ]\n[Example: \"minecraft:bee,minecraft:the_nether\"]")
        public List<String> entityDimensionWhitelist = new ArrayList<String>();
        @Comment(value="A list of dimensions that won't have flat entities [Syntax: \"modid:dimension\" ]\n[Example: \"minecraft:the_nether\"]")
        public List<String> dimensionBlacklist = new ArrayList<String>();
        @Comment(value="Invert the Dimension Blacklist")
        public boolean invertDimensionBlacklist = false;
    }
}

