/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.flatterentities.FlatterInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class Flattener {
    public static boolean renderingEnabled = true;
    public static final List<EntityType<?>> entityBlacklist = new ArrayList();
    public static final Map<ResourceKey<Level>, List<EntityType<?>>> entityDimensionWhitelist = new HashMap();
    public static final List<ResourceKey<Level>> dimensionBlacklist = new ArrayList<ResourceKey<Level>>();
    public static boolean dimensionListIsWhitelist = false;

    public static void prepareFlatRendering(float rotation, double x, double z, PoseStack poseStack, EntityRenderState renderState) {
        if (renderingEnabled && renderState instanceof FlatterInfo) {
            FlatterInfo info = (FlatterInfo)renderState;
            EntityType<?> entityType = info.flatterentities$getEntityType();
            ResourceKey<Level> entityDimension = info.flatterentities$getDimension();
            boolean isPlayer = renderState instanceof PlayerRenderState;
            boolean entityInList = entityBlacklist.contains(entityType);
            boolean worldInList = dimensionBlacklist.contains(entityDimension);
            boolean entityBlacklisted = !entityBlacklist.isEmpty() && entityInList;
            boolean dimensionFlat = dimensionBlacklist.isEmpty() || !dimensionBlacklist.isEmpty() && dimensionListIsWhitelist == worldInList;
            boolean renderAnyway = false;
            if (!dimensionBlacklist.isEmpty() && !entityDimensionWhitelist.isEmpty()) {
                List whitelist = entityDimensionWhitelist.getOrDefault(entityDimension, new ArrayList());
                boolean bl = renderAnyway = whitelist.contains(entityType) && !entityBlacklisted;
            }
            if (!entityBlacklisted && (dimensionFlat || renderAnyway)) {
                CameraType viewPoint = Minecraft.getInstance().options.getCameraType();
                float offset = 0.0f;
                double angle1 = Mth.wrapDegrees((double)(Math.atan2(z, x) / Math.PI * 180.0));
                double angle2 = Mth.wrapDegrees((double)(Math.floor(((double)rotation - angle1) / 45.0) * 45.0));
                if (isPlayer) {
                    offset = ((PlayerRenderState)renderState).yRot;
                }
                if (isPlayer) {
                    if (viewPoint == CameraType.FIRST_PERSON || viewPoint == CameraType.THIRD_PERSON_BACK) {
                        angle1 = -90.0f - offset;
                    }
                    if (viewPoint == CameraType.THIRD_PERSON_FRONT) {
                        angle1 = 90.0f + offset;
                    }
                }
                poseStack.mulPose(Axis.YP.rotationDegrees((float)angle1));
                poseStack.scale(0.02f, 1.0f, 1.0f);
                if (isPlayer) {
                    if (viewPoint == CameraType.FIRST_PERSON || viewPoint == CameraType.THIRD_PERSON_BACK) {
                        angle2 = 90.0f + offset;
                    }
                    if (viewPoint == CameraType.THIRD_PERSON_FRONT) {
                        angle2 = -90.0f - offset;
                    }
                }
                poseStack.mulPose(Axis.YP.rotationDegrees((float)angle2));
            }
        }
    }

    public static <T extends LivingEntity> float getYawRotation(T entityIn, float partialTicks, boolean shouldSit) {
        Entity entity;
        float lerpedBody = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float lerpedHead = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        if (shouldSit && (entity = entityIn.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            lerpedBody = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            float f2 = lerpedHead - lerpedBody;
            float degrees = Mth.wrapDegrees((float)f2);
            if (degrees < -85.0f) {
                degrees = -85.0f;
            }
            if (degrees >= 85.0f) {
                degrees = 85.0f;
            }
            lerpedBody = lerpedHead - degrees;
            if (degrees * degrees > 2500.0f) {
                lerpedBody += degrees * 0.2f;
            }
        }
        return lerpedBody;
    }
}

