/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities.mixin;

import com.mrbysco.flatterentities.Flattener;
import com.mrbysco.flatterentities.FlatterInfo;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin<T extends Entity, S extends EntityRenderState> {
    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/client/renderer/entity/state/EntityRenderState;F)V"}, at={@At(value="HEAD")})
    private void dostuff(T entity, S reusedState, float partialTick, CallbackInfo ci) {
        if (reusedState instanceof FlatterInfo) {
            FlatterInfo flatterLerp = (FlatterInfo)reusedState;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                boolean shouldSit = livingEntity.isPassenger() && livingEntity.getVehicle() != null && livingEntity.getVehicle().shouldRiderSit();
                Flattener.getYawRotation(livingEntity, partialTick, shouldSit);
            } else {
                flatterLerp.flatterentities$setYawLerp(Mth.rotLerp((float)partialTick, (float)((Entity)entity).yRotO, (float)entity.getYRot()));
            }
            flatterLerp.flatterentities$setEntityType(entity.getType());
            flatterLerp.flatterentities$setDimension((ResourceKey<Level>)entity.level().dimension());
        }
    }
}

