/*
 * Decompiled with CFR 0.152.
 */
package com.fortitude.fortitudemod;

import com.fortitude.fortitudemod.Config;
import com.fortitude.fortitudemod.ModDataStorage;
import com.fortitude.fortitudemod.eCalculationMethod;
import com.fortitude.fortitudemod.eRewardType;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ArmorGiver {
    private static UUID regularMobModifierUUID = UUID.fromString("e73251ab-12d4-46c5-a520-cf37624561a8");
    private static UUID eliteMobModifierUUID = UUID.fromString("aecc36c0-0e75-41ad-8e34-078306eb48c7");
    private static Attribute regularAttribute = Attributes.f_22284_;
    private static Attribute eliteAttribute = Attributes.f_22276_;

    public static void updateArmor(UUID playerID) {
        ServerPlayer player = ModDataStorage.server.m_6846_().m_11259_(playerID);
        int regularOutput = ArmorGiver.giveRegularArmor(playerID, player);
        if (regularOutput == 1) {
            message = Component.m_237113_((String)"You\u2019ve gained valuable insight from this encounter.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            player.m_213846_((Component)message);
        } else if (regularOutput == -1) {
            message = Component.m_237113_((String)"You've lost armor\u2014did you change the configs?").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            player.m_213846_((Component)message);
        }
        int eliteOutput = ArmorGiver.giveEliteArmor(playerID, player);
        if (eliteOutput == 1) {
            MutableComponent message = Component.m_237113_((String)"You\u2019ve gained profound wisdom from this encounter.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x6600CC)));
            player.m_213846_((Component)message);
        } else if (eliteOutput == -1) {
            MutableComponent message = Component.m_237113_((String)"You've lost armor\u2014did you change the configs?").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            player.m_213846_((Component)message);
        }
    }

    public static void updateArmorWithoutMessage(UUID playerID) {
        ServerPlayer player = ModDataStorage.server.m_6846_().m_11259_(playerID);
        ArmorGiver.giveRegularArmor(playerID, player);
        ArmorGiver.giveEliteArmor(playerID, player);
    }

    private static int giveRegularArmor(UUID playerID, ServerPlayer player) {
        ArmorGiver.setRegularAttribute();
        AttributeModifier regularModifier = player.m_21051_(regularAttribute).m_22111_(regularMobModifierUUID);
        double regularArmorAmount = regularModifier != null ? regularModifier.m_22218_() : 0.0;
        double newRegularArmorAmount = ArmorGiver.calculateArmor(playerID);
        if (((Boolean)Config.REGULAR_MOB_INTEGER_GAPS.get()).booleanValue()) {
            newRegularArmorAmount = (int)newRegularArmorAmount;
        }
        if (regularArmorAmount != newRegularArmorAmount) {
            player.m_21051_(regularAttribute).m_22120_(regularMobModifierUUID);
            AttributeModifier updatedArmorModifier = new AttributeModifier(regularMobModifierUUID, "unique-mob-kill-armor-booster", newRegularArmorAmount, AttributeModifier.Operation.ADDITION);
            player.m_21051_(regularAttribute).m_22118_(updatedArmorModifier);
            if (!((Boolean)Config.REGULAR_MOB_INTEGER_GAPS.get()).booleanValue()) {
                return 0;
            }
            if (regularArmorAmount < newRegularArmorAmount) {
                return 1;
            }
            if (regularArmorAmount > newRegularArmorAmount) {
                return -1;
            }
        }
        return 0;
    }

    private static int giveEliteArmor(UUID playerID, ServerPlayer player) {
        ArmorGiver.setEliteAttribute();
        AttributeModifier eliteModifier = player.m_21051_(eliteAttribute).m_22111_(eliteMobModifierUUID);
        double eliteArmorAmount = eliteModifier != null ? eliteModifier.m_22218_() : 0.0;
        double newEliteArmorAmount = (double)ModDataStorage.getUniqueEliteKillCount(playerID) * (Double)Config.ELITE_MULTIPLIER.get();
        if (((Boolean)Config.ELITE_MOB_INTEGER_GAPS.get()).booleanValue()) {
            newEliteArmorAmount = (int)newEliteArmorAmount;
        }
        if (eliteArmorAmount != newEliteArmorAmount) {
            player.m_21051_(eliteAttribute).m_22120_(eliteMobModifierUUID);
            AttributeModifier updatedEliteArmorModifier = new AttributeModifier(eliteMobModifierUUID, "unique-elite-kill-armor-booster", newEliteArmorAmount, AttributeModifier.Operation.ADDITION);
            player.m_21051_(eliteAttribute).m_22118_(updatedEliteArmorModifier);
            if (eliteArmorAmount < newEliteArmorAmount) {
                return 1;
            }
            if (eliteArmorAmount > newEliteArmorAmount) {
                return -1;
            }
        }
        return 0;
    }

    private static double calculateArmor(UUID playerID) {
        eCalculationMethod method = (eCalculationMethod)((Object)Config.CALCULATION_METHOD.get());
        int killCount = ModDataStorage.getUniqueRegularKillCount(playerID);
        if (method == eCalculationMethod.linear) {
            return (double)((int)((double)killCount / (Double)Config.LINEAR_GAPS.get())) * (Double)Config.LINEAR_MULTIP.get();
        }
        if (method == eCalculationMethod.logarithmic) {
            return Math.log(killCount) / Math.log((Double)Config.LOGARITHMIC_BASE.get());
        }
        if (method == eCalculationMethod.root) {
            return Math.pow(killCount, 1.0 / (Double)Config.ROOT_INDEX.get());
        }
        if (method == eCalculationMethod.exponential) {
            return Math.pow(killCount, (Double)Config.EXPONENTIAL_EXPONENT.get());
        }
        if (method == eCalculationMethod.incremental) {
            int result = 0;
            double lastDecrease = (Double)Config.INCREMENTAL_START.get();
            while (killCount > 0) {
                killCount = (int)((double)killCount - lastDecrease);
                lastDecrease += ((Double)Config.INCREMENTAL_INCREASE.get()).doubleValue();
                if (killCount < 0) continue;
                ++result;
            }
            return (double)result * (Double)Config.INCREMENTAL_MULTIPLIER.get();
        }
        return 0.0;
    }

    private static void setRegularAttribute() {
        eRewardType reward = (eRewardType)((Object)Config.REGULAR_MOB_REWARD.get());
        if (reward == eRewardType.armor) {
            regularAttribute = Attributes.f_22284_;
        } else if (reward == eRewardType.health) {
            regularAttribute = Attributes.f_22276_;
        } else if (reward == eRewardType.armorToughness) {
            regularAttribute = Attributes.f_22285_;
        } else if (reward == eRewardType.movementSpeed) {
            regularAttribute = Attributes.f_22279_;
        } else if (reward == eRewardType.attackSpeed) {
            regularAttribute = Attributes.f_22283_;
        } else if (reward == eRewardType.luck) {
            regularAttribute = Attributes.f_22286_;
        }
    }

    private static void setEliteAttribute() {
        eRewardType reward = (eRewardType)((Object)Config.ELITE_MOB_REWARD.get());
        if (reward == eRewardType.armor) {
            eliteAttribute = Attributes.f_22284_;
        } else if (reward == eRewardType.health) {
            eliteAttribute = Attributes.f_22276_;
        } else if (reward == eRewardType.armorToughness) {
            eliteAttribute = Attributes.f_22285_;
        } else if (reward == eRewardType.movementSpeed) {
            eliteAttribute = Attributes.f_22279_;
        } else if (reward == eRewardType.attackSpeed) {
            eliteAttribute = Attributes.f_22283_;
        } else if (reward == eRewardType.luck) {
            eliteAttribute = Attributes.f_22286_;
        }
    }
}

