/*
 * Decompiled with CFR 0.152.
 */
package com.fortitude.fortitudemod;

import com.fortitude.fortitudemod.eCalculationMethod;
import com.fortitude.fortitudemod.eRewardType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="fortitudemod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ELITE_MOBS;
    public static final ForgeConfigSpec.BooleanValue REGULAR_MOB_INTEGER_GAPS;
    public static final ForgeConfigSpec.EnumValue<eCalculationMethod> CALCULATION_METHOD;
    public static final ForgeConfigSpec.EnumValue<eRewardType> REGULAR_MOB_REWARD;
    public static final ForgeConfigSpec.DoubleValue LINEAR_GAPS;
    public static final ForgeConfigSpec.DoubleValue LINEAR_MULTIP;
    public static final ForgeConfigSpec.DoubleValue LOGARITHMIC_BASE;
    public static final ForgeConfigSpec.DoubleValue EXPONENTIAL_EXPONENT;
    public static final ForgeConfigSpec.DoubleValue ROOT_INDEX;
    public static final ForgeConfigSpec.DoubleValue INCREMENTAL_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue INCREMENTAL_START;
    public static final ForgeConfigSpec.DoubleValue INCREMENTAL_INCREASE;
    public static final ForgeConfigSpec.DoubleValue ELITE_MULTIPLIER;
    public static final ForgeConfigSpec.BooleanValue ELITE_MOB_INTEGER_GAPS;
    public static final ForgeConfigSpec.EnumValue<eRewardType> ELITE_MOB_REWARD;
    public static final ForgeConfigSpec.BooleanValue UPDATE_ON_LOGIN;
    public static final ForgeConfigSpec SPEC;

    public static Set<EntityType<?>> getEliteMobsFromConfig() {
        return ((List)ELITE_MOBS.get()).stream().map(name -> {
            ResourceLocation id = new ResourceLocation(name);
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
        }).filter(entityType -> entityType != null).collect(Collectors.toSet());
    }

    static {
        BUILDER.push("regularMobSettings");
        BUILDER.push("regularMobReward");
        REGULAR_MOB_REWARD = BUILDER.comment("The reward granted for unique mob kills.").defineEnum("rewardType", (Enum)eRewardType.armor);
        BUILDER.pop();
        BUILDER.push("regularIntegerGaps");
        REGULAR_MOB_INTEGER_GAPS = BUILDER.comment("Makes it so the gaps between stat increases are integers. Should be turned off if you want decimal changes. Will also disable increase messages since increases will happen every unique kill.").define("regularIntegerGaps", true);
        BUILDER.pop();
        BUILDER.push("calculationMethod");
        CALCULATION_METHOD = BUILDER.comment("The calculation method used for value calculations.").defineEnum("calculationMethod", (Enum)eCalculationMethod.linear);
        BUILDER.pop();
        BUILDER.push("linear");
        LINEAR_GAPS = BUILDER.comment("The value of gaps in linear calculation. Example: 5 means every 5 kills.").defineInRange("linearGaps", 5.0, 1.0, Double.MAX_VALUE);
        LINEAR_MULTIP = BUILDER.comment("The multiplier for stats granted in linear calculation. Example: 3 means 3 stats. Do not forget to set regularIntegerGaps false if you want decimal values.").defineInRange("linearMultip", 1.0, 0.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("incremental");
        INCREMENTAL_START = BUILDER.comment("The start value for incremental calculation. Example: Start of 5 with a increase of 0 will give stats at 5,10,15... unique kills.").defineInRange("incrementalStart", 5.0, 1.0, Double.MAX_VALUE);
        INCREMENTAL_INCREASE = BUILDER.comment("The increase between gaps in incremental calculation. Example: Start of 5 with increase of 1 will give stats at 5,11,18,26... unique kills.").defineInRange("incrementalIncrease", 3.0, 0.0, Double.MAX_VALUE);
        INCREMENTAL_MULTIPLIER = BUILDER.comment("The amount of stats granted at the checkpoints in incremental calculation").defineInRange("incrementalMultip", 1.0, 0.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("logarithmic");
        LOGARITHMIC_BASE = BUILDER.comment("The base value for the logarithmic calculation.").defineInRange("logarithmicBase", 2.0, 1.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("exponential");
        EXPONENTIAL_EXPONENT = BUILDER.comment("The exponent value for the exponential calculation.").defineInRange("exponentialExponent", 2.0, 1.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("root");
        ROOT_INDEX = BUILDER.comment("The index of the root for root calculation.").defineInRange("rootIndex", 2.0, 1.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("eliteMobSettings");
        BUILDER.push("eliteMobs");
        ELITE_MOBS = BUILDER.comment("List of elite mobs by their registry name. Default: Wither, Ender Dragon, Warden. For vanilla minecraft:mob_name for modded modid:mob_name.").defineList("eliteMobs", List.of("minecraft:wither", "minecraft:ender_dragon", "minecraft:warden"), value -> value instanceof String);
        BUILDER.pop();
        BUILDER.push("eliteIntegerGaps");
        ELITE_MOB_INTEGER_GAPS = BUILDER.comment("Makes it so the gaps between stat increases are integers. Should be turned off if you want decimal changes. Will also disable increase messages since increases will happen unique every kill.").define("eliteIntegerGaps", true);
        BUILDER.pop();
        BUILDER.push("eliteMultiplier");
        ELITE_MULTIPLIER = BUILDER.comment("The amount of armor an unique elite will give upon defeat.").defineInRange("eliteMultiplier", 4.0, 0.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("eliteMobReward");
        ELITE_MOB_REWARD = BUILDER.comment("The reward granted for unique elite kills.").defineEnum("rewardType", (Enum)eRewardType.health);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("generalSettings");
        BUILDER.push("updateOnLogin");
        UPDATE_ON_LOGIN = BUILDER.comment("Refresh killed mobs on login if true. Disable only if causing issues.").define("updateOnLogin", true);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

