/*
 * Decompiled with CFR 0.152.
 */
package com.fortitude.fortitudemod;

import com.fortitude.fortitudemod.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="fortitudemod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModDataStorage {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String DATA_FILE = "serverconfig/fortitude/player_unique_mob_kills.json";
    private static JsonObject playerDataMap = new JsonObject();
    public static MinecraftServer server;

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        server = event.getServer();
        ModDataStorage.loadData(server);
    }

    public static void loadData(MinecraftServer server) {
        File file = new File(server.m_129843_(LevelResource.f_78182_).toFile(), DATA_FILE);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                playerDataMap = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                playerDataMap = new JsonObject();
            }
        } else {
            playerDataMap = new JsonObject();
        }
    }

    public static void saveData(MinecraftServer server) {
        File directory = new File(server.m_129843_(LevelResource.f_78182_).toFile(), "/serverconfig/fortitude/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File file = new File(server.m_129843_(LevelResource.f_78182_).toFile(), DATA_FILE);
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((JsonElement)playerDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void tryAddUniqueKill(UUID playerUUID, EntityType<?> mobType) {
        JsonObject playerData;
        JsonObject jsonObject = playerData = playerDataMap.has(playerUUID.toString()) ? playerDataMap.getAsJsonObject(playerUUID.toString()) : new JsonObject();
        if (ModDataStorage.isElite(mobType)) {
            JsonArray uniqueElites;
            JsonArray jsonArray = uniqueElites = playerData.has("uniqueElites") ? playerData.getAsJsonArray("uniqueElites") : new JsonArray();
            if (ModDataStorage.isUniqueElite(playerUUID, mobType)) {
                uniqueElites.add(EntityType.m_20613_(mobType).toString());
                playerData.add("uniqueElites", (JsonElement)uniqueElites);
                int currentKillCount = playerData.has("eliteKillCount") ? playerData.get("eliteKillCount").getAsInt() : 0;
                playerData.addProperty("eliteKillCount", (Number)(currentKillCount + 1));
            }
        } else {
            JsonArray uniqueMobs;
            JsonArray jsonArray = uniqueMobs = playerData.has("uniqueMobs") ? playerData.getAsJsonArray("uniqueMobs") : new JsonArray();
            if (ModDataStorage.isUniqueMob(playerUUID, mobType)) {
                uniqueMobs.add(EntityType.m_20613_(mobType).toString());
                playerData.add("uniqueMobs", (JsonElement)uniqueMobs);
                int currentKillCount = playerData.has("killCount") ? playerData.get("killCount").getAsInt() : 0;
                playerData.addProperty("killCount", (Number)(currentKillCount + 1));
            }
        }
        playerDataMap.add(playerUUID.toString(), (JsonElement)playerData);
        ModDataStorage.saveData(server);
    }

    public static boolean isUniqueMob(UUID playerUUID, EntityType<?> mobType) {
        JsonObject playerData = playerDataMap.getAsJsonObject(playerUUID.toString());
        if (playerData != null && playerData.has("uniqueMobs")) {
            JsonArray uniqueMobs = playerData.getAsJsonArray("uniqueMobs");
            for (JsonElement mob : uniqueMobs) {
                if (!mob.getAsString().equals(EntityType.m_20613_(mobType).toString())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isUniqueElite(UUID playerUUID, EntityType<?> mobType) {
        JsonObject playerData = playerDataMap.getAsJsonObject(playerUUID.toString());
        if (playerData != null && playerData.has("uniqueElites")) {
            JsonArray uniqueElites = playerData.getAsJsonArray("uniqueElites");
            for (JsonElement mob : uniqueElites) {
                if (!mob.getAsString().equals(EntityType.m_20613_(mobType).toString())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isElite(EntityType<?> mobType) {
        return Config.getEliteMobsFromConfig().contains(mobType);
    }

    public static boolean isElite(String mobType) {
        return ((List)Config.ELITE_MOBS.get()).contains(mobType);
    }

    public static int getUniqueRegularKillCount(UUID playerUUID) {
        JsonObject playerData = playerDataMap.getAsJsonObject(playerUUID.toString());
        if (playerData != null && playerData.has("killCount")) {
            return playerData.get("killCount").getAsInt();
        }
        return 0;
    }

    public static int getUniqueEliteKillCount(UUID playerUUID) {
        JsonObject playerData = playerDataMap.getAsJsonObject(playerUUID.toString());
        if (playerData != null && playerData.has("eliteKillCount")) {
            return playerData.get("eliteKillCount").getAsInt();
        }
        return 0;
    }

    public static List<String> getUniqueMobsKilled(UUID playerUUID) {
        JsonObject playerData = playerDataMap.getAsJsonObject(playerUUID.toString());
        ArrayList<String> uniqueMobs = new ArrayList<String>();
        if (playerData != null && playerData.has("uniqueMobs")) {
            JsonArray mobs = playerData.getAsJsonArray("uniqueMobs");
            for (JsonElement mob : mobs) {
                uniqueMobs.add(mob.getAsString());
            }
        }
        return uniqueMobs;
    }

    public static void UpdateKillCount(UUID playerUUID) {
        JsonObject playerData = playerDataMap.getAsJsonObject(playerUUID.toString());
        if (playerData != null) {
            JsonArray uniqueMobs = playerData.has("uniqueMobs") ? playerData.getAsJsonArray("uniqueMobs") : new JsonArray();
            JsonArray uniqueElites = playerData.has("uniqueElites") ? playerData.getAsJsonArray("uniqueElites") : new JsonArray();
            ModDataStorage.purifyField(uniqueMobs);
            ModDataStorage.purifyField(uniqueElites);
            JsonArray tempEliteContainer = new JsonArray();
            JsonArray tempRegularContainer = new JsonArray();
            for (JsonElement eliteMob : uniqueElites) {
                if (ModDataStorage.isElite(eliteMob.getAsString())) continue;
                tempEliteContainer.add(eliteMob);
            }
            for (JsonElement eliteMob : tempEliteContainer) {
                uniqueElites.remove(eliteMob);
                uniqueMobs.add(eliteMob);
            }
            for (JsonElement mob : uniqueMobs) {
                if (!ModDataStorage.isElite(mob.getAsString())) continue;
                tempRegularContainer.add(mob);
            }
            for (JsonElement mob : tempRegularContainer) {
                uniqueMobs.remove(mob);
                uniqueElites.add(mob);
            }
            playerData.addProperty("killCount", (Number)uniqueMobs.size());
            playerData.addProperty("eliteKillCount", (Number)uniqueElites.size());
            playerDataMap.add(playerUUID.toString(), (JsonElement)playerData);
        }
        ModDataStorage.saveData(server);
    }

    public static void ensureFieldsExist(JsonObject playerData) {
        if (!playerData.has("uniqueMobs")) {
            playerData.add("uniqueMobs", (JsonElement)new JsonArray());
        }
        if (!playerData.has("uniqueElites")) {
            playerData.add("uniqueElites", (JsonElement)new JsonArray());
        }
        if (!playerData.has("killCount")) {
            playerData.addProperty("killCount", (Number)0);
        }
        if (!playerData.has("eliteKillCount")) {
            playerData.addProperty("eliteKillCount", (Number)0);
        }
    }

    public static void purifyField(JsonArray mobArray) {
        JsonArray tempContainer = new JsonArray();
        for (JsonElement mob : mobArray) {
            ResourceLocation resourceLocation = new ResourceLocation(mob.getAsString());
            if (ForgeRegistries.ENTITY_TYPES.containsKey(resourceLocation)) continue;
            tempContainer.add(mob);
        }
        for (JsonElement mob : tempContainer) {
            mobArray.remove(mob);
        }
    }
}

